/// <reference path="./internal_*.d.ts" />
declare namespace com.simibubi.create.content.equipment.wrench {
    interface IWrenchable {
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
    }
    type IWrenchable_ = IWrenchable;
}
declare namespace Internal {
    class SlimeNyliumBlock extends Internal.Block implements Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, foliageType: Internal.SlimeType_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess(worldIn: Internal.Level_, rand: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(world: Internal.ServerLevel_, rand: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(worldIn: Internal.LevelReader_, pos: BlockPos_, state: Internal.BlockState_, isClient: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type SlimeNyliumBlock_ = SlimeNyliumBlock;
    class BlockEntityPredicate implements Internal.BlockPredicate {
        constructor(i: ResourceLocation_)
        data(cd: Internal.BlockEntityPredicateDataCheck_): this;
        check(block: Internal.BlockContainerJS_): boolean;
    }
    type BlockEntityPredicate_ = BlockEntityPredicate;
    class CartographyTableBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CartographyTableBlock_ = CartographyTableBlock;
    interface OwoScreenHandlerExtension {
        abstract owo$attachToPlayer(arg0: Internal.Player_): void;
        abstract owo$readPropertySync(arg0: Internal.FriendlyByteBuf_): void;
        abstract owo$handlePacket(arg0: Internal.FriendlyByteBuf_, arg1: boolean): void;
    }
    type OwoScreenHandlerExtension_ = OwoScreenHandlerExtension;
    class AgriSeed extends Internal.Record {
        constructor(item: Internal.ExtraCodecs$TagOrElementLocation_, overridePlanting: boolean, nbt: Internal.Optional_<Internal.CompoundTag>, grassDropChance: number, seedDropChance: number, seedDropBonus: number)
        constructor(item: Internal.ExtraCodecs$TagOrElementLocation_, overridePlanting: boolean, nbt: Internal.CompoundTag_, grassDropChance: number, seedDropChance: number, seedDropBonus: number)
        seedDropBonus(): number;
        overridePlanting(): boolean;
        static builder(): Internal.AgriSeed$Builder;
        nbt(): Internal.CompoundTag;
        item(): Internal.ExtraCodecs$TagOrElementLocation;
        grassDropChance(): number;
        isVariant(itemStack: Internal.ItemStack_): boolean;
        seedDropChance(): number;
        static readonly CODEC: Internal.Codec<Internal.AgriSeed>;
    }
    type AgriSeed_ = AgriSeed;
    class ShapelessRecipe$Serializer implements Internal.RecipeSerializer<Internal.ShapelessRecipe> {
        constructor()
        toNetwork($$0: Internal.FriendlyByteBuf_, $$1: Internal.ShapelessRecipe_): void;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        "handler$edi001$lib39-core$lib39Core$read"(identifier: ResourceLocation_, jsonObject: Internal.JsonObject_, ci: Internal.CallbackInfoReturnable_<any>): void;
        fromNetwork($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_): Internal.ShapelessRecipe;
        fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): Internal.ShapelessRecipe;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type ShapelessRecipe$Serializer_ = ShapelessRecipe$Serializer;
    interface Surface {
        flat(color: number): this;
        parse(surfaceElement: Internal.Element_): this;
        blur(quality: number, size: number): this;
        tiled(texture: ResourceLocation_, textureWidth: number, textureHeight: number): this;
        outline(color: number): this;
        and(surface: Internal.Surface_): this;
        abstract draw(arg0: Internal.OwoUIDrawContext_, arg1: Internal.ParentComponent_): void;
        (arg0: Internal.OwoUIDrawContext, arg1: Internal.ParentComponent): void;
        readonly BLANK: Internal.Surface;
        readonly PANEL: Internal.Surface;
        readonly OPTIONS_BACKGROUND: Internal.Surface;
        readonly DARK_PANEL: Internal.Surface;
        readonly PANEL_INSET: Internal.Surface;
        readonly TOOLTIP: Internal.Surface;
        readonly VANILLA_TRANSLUCENT: Internal.Surface;
    }
    type Surface_ = Surface;
    class SoundBuffer {
        constructor($$0: Internal.ByteBuffer_, $$1: Internal.AudioFormat_)
        discardAlBuffer(): void;
        releaseAlBuffer(): Internal.OptionalInt;
    }
    type SoundBuffer_ = SoundBuffer;
    class ResolvedModule {
        name(): string;
        configuration(): Internal.Configuration;
        reads(): Internal.Set<Internal.ResolvedModule>;
        reference(): Internal.ModuleReference;
    }
    type ResolvedModule_ = ResolvedModule;
    class Rotations {
        constructor($$0: Internal.ListTag_)
        constructor($$0: number, $$1: number, $$2: number)
        getX(): number;
        getWrappedZ(): number;
        getZ(): number;
        getWrappedY(): number;
        getY(): number;
        getWrappedX(): number;
        save(): Internal.ListTag;
        get x(): number
        get wrappedZ(): number
        get z(): number
        get wrappedY(): number
        get y(): number
        get wrappedX(): number
    }
    type Rotations_ = Rotations;
    interface IntIterable extends Internal.Iterable<number> {
        iterator(): Internal.Iterator<any>;
        spliterator(): Internal.Spliterator<any>;
        forEach(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        forEach(arg0: Internal.IntConsumer_): void;
        intIterator(): Internal.IntIterator;
        intSpliterator(): Internal.IntSpliterator;
    }
    type IntIterable_ = IntIterable;
    class InputReplacementTransformer$Replacement extends Internal.Record implements Internal.InputReplacement {
        constructor(with_: Internal.InputReplacement_, transformer: Internal.InputReplacementTransformer_)
        replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
        static of(o: any): Internal.InputReplacement;
        transform(transformer: Internal.InputReplacementTransformer_): this;
        "with"(): Internal.InputReplacement;
        transformer(): Internal.InputReplacementTransformer;
    }
    type InputReplacementTransformer$Replacement_ = InputReplacementTransformer$Replacement;
    class FluidBlockBuilder extends Internal.BlockBuilder {
        constructor(b: Internal.FluidBuilder_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
    }
    type FluidBlockBuilder_ = FluidBlockBuilder;
    interface AccessorRecipeManager {
        abstract bookshelf$getTypeMap(arg0: Internal.RecipeType_<any>): Internal.Map<any, any>;
        (arg0: Internal.RecipeType<any>): Internal.Map_<any, any>;
    }
    type AccessorRecipeManager_ = AccessorRecipeManager;
    class BlockStateComponent extends Internal.Record implements Internal.RecipeComponent<Internal.BlockState> {
        constructor(crole: Internal.ComponentRole_, preferObjectForm: boolean)
        preferObjectForm(): boolean;
        replaceInput(recipe: Internal.RecipeJS_, original: Internal.BlockState_, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): Internal.BlockState;
        write(arg0: Internal.RecipeJS_, arg1: any): Internal.JsonElement;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, Internal.BlockState>>;
        role(): Internal.ComponentRole;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.BlockState>, map: Internal.Map_<any, any>): void;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.BlockState>, json: Internal.JsonObject_): void;
        componentClass(): typeof any;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.BlockState>;
        isInput(recipe: Internal.RecipeJS_, value: Internal.BlockState_, match: Internal.ReplacementMatch_): boolean;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<Internal.BlockState, O>;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, Internal.BlockState>>;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.BlockState>, json: Internal.JsonObject_): void;
        componentType(): string;
        checkEmpty(arg0: Internal.RecipeKey_<any>, arg1: any): string;
        checkEmpty(key: Internal.RecipeKey_<Internal.BlockState>, value: Internal.BlockState_): string;
        static builder(): Internal.RecipeComponentBuilder;
        asArray(): Internal.ArrayRecipeComponent<Internal.BlockState>;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        crole(): Internal.ComponentRole;
        isOutput(recipe: Internal.RecipeJS_, value: Internal.BlockState_, match: Internal.ReplacementMatch_): boolean;
        static builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        read(arg0: Internal.RecipeJS_, arg1: any): any;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<Internal.BlockState>;
        isOutput(arg0: Internal.RecipeJS_, arg1: any, arg2: Internal.ReplacementMatch_): boolean;
        key(name: string): Internal.RecipeKey<Internal.BlockState>;
        replaceOutput(recipe: Internal.RecipeJS_, original: Internal.BlockState_, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): Internal.BlockState;
        orSelf(): Internal.RecipeComponent<Internal.BlockState>;
        write(recipe: Internal.RecipeJS_, value: Internal.BlockState_): Internal.JsonElement;
        checkValueHasChanged(oldValue: Internal.BlockState_, newValue: Internal.BlockState_): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.BlockState>;
        isInput(arg0: Internal.RecipeJS_, arg1: any, arg2: Internal.ReplacementMatch_): boolean;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<Internal.BlockState>;
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<Internal.BlockState, O>;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<Internal.BlockState>;
        static readonly BLOCK_STRING: Internal.BlockStateComponent;
        static readonly BLOCK: Internal.BlockStateComponent;
        static readonly INPUT_STRING: Internal.BlockStateComponent;
        static readonly INPUT: Internal.BlockStateComponent;
        static readonly OUTPUT_STRING: Internal.BlockStateComponent;
        static readonly OUTPUT: Internal.BlockStateComponent;
    }
    type BlockStateComponent_ = BlockStateComponent;
    class BacktankItem$Layered extends Internal.BacktankItem implements Internal.LayeredArmorItem {
        constructor(material: Internal.ArmorMaterial_, properties: Internal.Item$Properties_, textureLoc: ResourceLocation_, placeable: Internal.Supplier_<Internal.BacktankItem$BacktankBlockItem>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        getArmorTextureLocation(entity: Internal.LivingEntity_, slot: Internal.EquipmentSlot_, stack: Internal.ItemStack_, layer: number): string;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        renderArmorPiece(layer: Internal.HumanoidArmorLayer_<any, any, any>, poseStack: Internal.PoseStack_, bufferSource: Internal.MultiBufferSource_, entity: Internal.LivingEntity_, slot: Internal.EquipmentSlot_, light: number, originalModel: Internal.HumanoidModel_<any>, stack: Internal.ItemStack_): void;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BacktankItem$Layered_ = BacktankItem$Layered;
    class CraftingMonitorBlock extends Internal.AbstractCraftingUnitBlock<any> {
        constructor(type: Internal.ICraftingUnitType_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CraftingMonitorBlock_ = CraftingMonitorBlock;
    interface TickContainerAccess <T> extends Internal.TickAccess<T> {
        abstract count(): number;
        abstract schedule(arg0: Internal.ScheduledTick_<T>): void;
        abstract hasScheduledTick(arg0: BlockPos_, arg1: T): boolean;
    }
    type TickContainerAccess_<T> = TickContainerAccess<T>;
    interface GeneratedClassLoader {
        abstract linkClass(arg0: typeof any): void;
        abstract defineClass(arg0: string, arg1: number[]): typeof any;
    }
    type GeneratedClassLoader_ = GeneratedClassLoader;
    class TileCrystalFixer extends Internal.AENetworkInvBlockEntity implements Internal.IGridTickable {
        constructor(pos: BlockPos_, blockState: Internal.BlockState_)
        getProgress(): number;
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onMainNodeStateChanged(reason: Internal.IGridNodeListener$State_): void;
        onLoad(): void;
        refuel(player: Internal.Player_): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getTickingRequest(node: Internal.IGridNode_): Internal.TickingRequest;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        tickingRequest(node: Internal.IGridNode_, ticksSinceLastCall: number): Internal.TickRateModulation;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get progress(): number
        get displayName(): net.minecraft.network.chat.Component
        get gridNode(): Internal.IGridNode
        get actionableNode(): Internal.IGridNode
        set owner(owner: Internal.Player_)
    }
    type TileCrystalFixer_ = TileCrystalFixer;
    class AECableSize extends Internal.Enum<Internal.AECableSize> {
        static valueOf(name: string): Internal.AECableSize;
        static max(a: Internal.AECableSize_, b: Internal.AECableSize_): Internal.AECableSize;
        static min(a: Internal.AECableSize_, b: Internal.AECableSize_): Internal.AECableSize;
        static values(): Internal.AECableSize[];
        static readonly NONE: Internal.AECableSize;
        static readonly DENSE: Internal.AECableSize;
        static readonly NORMAL: Internal.AECableSize;
    }
    type AECableSize_ = "normal" | AECableSize | "none" | "dense";
    abstract class GlyphVector implements Internal.Cloneable {
        abstract setGlyphTransform(arg0: number, arg1: Internal.AffineTransform_): void;
        abstract setGlyphPosition(arg0: number, arg1: Internal.Point2D_): void;
        abstract getGlyphVisualBounds(arg0: number): Internal.Shape;
        abstract getGlyphTransform(arg0: number): Internal.AffineTransform;
        abstract getGlyphLogicalBounds(arg0: number): Internal.Shape;
        abstract getGlyphOutline(arg0: number): Internal.Shape;
        abstract getFont(): Internal.Font;
        abstract getGlyphJustificationInfo(arg0: number): Internal.GlyphJustificationInfo;
        abstract getGlyphPosition(arg0: number): Internal.Point2D;
        abstract getVisualBounds(): Internal.Rectangle2D;
        getPixelBounds(arg0: Internal.FontRenderContext_, arg1: number, arg2: number): Internal.Rectangle;
        getGlyphPixelBounds(arg0: number, arg1: Internal.FontRenderContext_, arg2: number, arg3: number): Internal.Rectangle;
        getGlyphCharIndices(arg0: number, arg1: number, arg2: number[]): number[];
        abstract getGlyphCodes(arg0: number, arg1: number, arg2: number[]): number[];
        abstract getGlyphMetrics(arg0: number): Internal.GlyphMetrics;
        abstract getFontRenderContext(): Internal.FontRenderContext;
        abstract getOutline(arg0: number, arg1: number): Internal.Shape;
        abstract performDefaultLayout(): void;
        abstract getGlyphCode(arg0: number): number;
        abstract getGlyphPositions(arg0: number, arg1: number, arg2: number[]): number[];
        abstract getOutline(): Internal.Shape;
        getLayoutFlags(): number;
        abstract equals(arg0: Internal.GlyphVector_): boolean;
        getGlyphCharIndex(arg0: number): number;
        abstract getLogicalBounds(): Internal.Rectangle2D;
        abstract getNumGlyphs(): number;
        getGlyphOutline(arg0: number, arg1: number, arg2: number): Internal.Shape;
        get font(): Internal.Font
        get visualBounds(): Internal.Rectangle2D
        get fontRenderContext(): Internal.FontRenderContext
        get outline(): Internal.Shape
        get layoutFlags(): number
        get logicalBounds(): Internal.Rectangle2D
        get numGlyphs(): number
        static readonly FLAG_COMPLEX_GLYPHS: 8;
        static readonly FLAG_HAS_TRANSFORMS: 1;
        static readonly FLAG_MASK: 15;
        static readonly FLAG_RUN_RTL: 4;
        static readonly FLAG_HAS_POSITION_ADJUSTMENTS: 2;
    }
    type GlyphVector_ = GlyphVector;
    class FreezeRecipe implements Internal.Recipe<net.minecraft.world.Container> {
        constructor(resId: ResourceLocation_, blockIn: Internal.StateIngredient_, result: Internal.BlockState_)
        component2(): Internal.StateIngredient;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        matches(blockIn: Internal.BlockState_): boolean;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(pContainer: net.minecraft.world.Container_, access: Internal.RegistryAccess_): Internal.ItemStack;
        component1(): ResourceLocation;
        getId(): ResourceLocation;
        static copy$default(arg0: Internal.FreezeRecipe_, arg1: ResourceLocation_, arg2: Internal.StateIngredient_, arg3: Internal.BlockState_, arg4: number, arg5: any): Internal.FreezeRecipe;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(pContainer: net.minecraft.world.Container_, pLevel: Internal.Level_): boolean;
        getMod(): string;
        component3(): Internal.BlockState;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getResId(): ResourceLocation;
        getResult(): Internal.BlockState;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        copy(resId: ResourceLocation_, blockIn: Internal.StateIngredient_, result: Internal.BlockState_): this;
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions(pWidth: number, pHeight: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getBlockIn(): Internal.StateIngredient;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get resId(): ResourceLocation
        get result(): Internal.BlockState
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get blockIn(): Internal.StateIngredient
    }
    type FreezeRecipe_ = FreezeRecipe;
    interface CustomRunningEffectsBlock {
        abstract addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        (arg0: Internal.BlockState, arg1: Internal.Level, arg2: BlockPos, arg3: Internal.Entity): boolean;
    }
    type CustomRunningEffectsBlock_ = CustomRunningEffectsBlock;
    class ReplaceBlobsFeature extends Internal.Feature<Internal.ReplaceSphereConfiguration> {
        constructor($$0: Internal.Codec_<Internal.ReplaceSphereConfiguration>)
    }
    type ReplaceBlobsFeature_ = ReplaceBlobsFeature;
    class BlazeBurnerBlock$HeatLevel extends Internal.Enum<Internal.BlazeBurnerBlock$HeatLevel> implements Internal.StringRepresentable {
        static byIndex(index: number): Internal.BlazeBurnerBlock$HeatLevel;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.BlazeBurnerBlock$HeatLevel;
        nextActiveLevel(): this;
        isAtLeast(heatLevel: Internal.BlazeBurnerBlock$HeatLevel_): boolean;
        getSerializedName(): string;
        static values(): Internal.BlazeBurnerBlock$HeatLevel[];
        get serializedName(): string
        static readonly KINDLED: Internal.BlazeBurnerBlock$HeatLevel;
        static readonly NONE: Internal.BlazeBurnerBlock$HeatLevel;
        static readonly SEETHING: Internal.BlazeBurnerBlock$HeatLevel;
        static readonly FADING: Internal.BlazeBurnerBlock$HeatLevel;
        static readonly SMOULDERING: Internal.BlazeBurnerBlock$HeatLevel;
    }
    type BlazeBurnerBlock$HeatLevel_ = "smouldering" | "kindled" | BlazeBurnerBlock$HeatLevel | "fading" | "seething" | "none";
    class BatteryItem extends Internal.EnergyItem<owmii.powah.block.Tier, Internal.EnergyConfig, Internal.BatteryItem> implements Internal.IEnderExtender {
        constructor(properties: Internal.Item$Properties_, variant: owmii.powah.block.Tier_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getConfig(): Internal.IEnergyConfig<owmii.powah.block.Tier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getExtendedCapacity(stack: Internal.ItemStack_): number;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getExtendedEnergy(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get config(): Internal.IEnergyConfig<owmii.powah.block.Tier>
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BatteryItem_ = BatteryItem;
    class ChunkPos {
        constructor($$0: BlockPos_)
        constructor($$0: number, $$1: number)
        constructor($$0: number)
        getWorldPosition(): BlockPos;
        static getX($$0: number): number;
        static maxFromRegion($$0: number, $$1: number): Internal.ChunkPos;
        getMinBlockZ(): number;
        static getZ($$0: number): number;
        getMinBlockX(): number;
        static hash($$0: number, $$1: number): number;
        getMaxBlockX(): number;
        getRegionLocalX(): number;
        getMaxBlockZ(): number;
        getMiddleBlockX(): number;
        getMiddleBlockZ(): number;
        getRegionLocalZ(): number;
        getBlockAt($$0: number, $$1: number, $$2: number): BlockPos;
        static rangeClosed($$0: Internal.ChunkPos_, $$1: number): Internal.Stream<Internal.ChunkPos>;
        getRegionZ(): number;
        getChessboardDistance($$0: Internal.ChunkPos_): number;
        static minFromRegion($$0: number, $$1: number): Internal.ChunkPos;
        static asLong($$0: number, $$1: number): number;
        getRegionX(): number;
        getMiddleBlockPosition($$0: number): BlockPos;
        getBlockX($$0: number): number;
        static asLong($$0: BlockPos_): number;
        getBlockZ($$0: number): number;
        static rangeClosed($$0: Internal.ChunkPos_, $$1: Internal.ChunkPos_): Internal.Stream<Internal.ChunkPos>;
        toLong(): number;
        get worldPosition(): BlockPos
        get minBlockZ(): number
        get minBlockX(): number
        get maxBlockX(): number
        get regionLocalX(): number
        get maxBlockZ(): number
        get middleBlockX(): number
        get middleBlockZ(): number
        get regionLocalZ(): number
        get regionZ(): number
        get regionX(): number
        static readonly REGION_SIZE: 32;
        static readonly ZERO: Internal.ChunkPos;
        readonly z: number;
        static readonly INVALID_CHUNK_POS: 8053347149716602;
        readonly x: number;
        static readonly REGION_MAX_INDEX: 31;
    }
    type ChunkPos_ = ChunkPos;
    interface Animation$Finished {
        abstract onFinished(arg0: Internal.Animation$Direction_, arg1: boolean): void;
        newStream(): Internal.EventStream<Internal.Animation$Finished>;
        (arg0: Internal.Animation$Direction, arg1: boolean): void;
    }
    type Animation$Finished_ = Animation$Finished;
    interface SkullBlock$Type {
    }
    type SkullBlock$Type_ = SkullBlock$Type;
    class PotatoBlock extends Internal.CropBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type PotatoBlock_ = PotatoBlock;
    interface Object2IntMap <K> extends Internal.Map<K, number>, Internal.Object2IntFunction<K> {
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2IntFunction<T>;
        /**
         * @deprecated
        */
        mergeInt(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        containsValue(arg0: any): boolean;
        abstract defaultReturnValue(): number;
        removeInt(arg0: any): number;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2IntFunction;
        apply(arg0: K): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2IntFunction;
        abstract getInt(arg0: any): number;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: K, arg1: number): number;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any, arg2: any): boolean;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        computeIntIfAbsentPartial(arg0: K, arg1: Internal.Object2IntFunction_<K>): number;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        replace(arg0: K, arg1: number, arg2: number): boolean;
        andThenInt(arg0: Internal.Int2IntFunction_): Internal.Object2IntFunction<K>;
        computeIfAbsent(arg0: K, arg1: Internal.Object2IntFunction_<K>): number;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        replaceAll(arg0: Internal.BiFunction_<K, number, number>): void;
        replace(arg0: K, arg1: number): number;
        applyAsInt(arg0: K): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Object2ByteFunction<K>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        getOrDefault(arg0: any, arg1: number): number;
        identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        putIfAbsent(arg0: any, arg1: any): any;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        put(arg0: K, arg1: number): number;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Object2FloatFunction<K>;
        /**
         * @deprecated
        */
        computeIntIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2IntFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        of<K, V>(): Internal.Map<K, V>;
        mergeInt(arg0: K, arg1: number, arg2: Internal.IntBinaryOperator_): number;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        /**
         * @deprecated
        */
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        merge(arg0: K, arg1: number, arg2: Internal.BiFunction_<number, number, number>): number;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Object2ShortFunction<K>;
        abstract containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<K, number>>;
        computeIfAbsent(arg0: K, arg1: Internal.ToIntFunction_<K>): number;
        abstract containsValue(arg0: number): boolean;
        /**
         * @deprecated
        */
        replace(arg0: K, arg1: number, arg2: number): boolean;
        computeInt(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        abstract keySet(): Internal.ObjectSet<K>;
        remove(arg0: any, arg1: number): boolean;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        /**
         * @deprecated
        */
        remove(arg0: any, arg1: any): boolean;
        computeIntIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2IntFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2IntFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        mergeInt(arg0: K, arg1: number, arg2: it.unimi.dsi.fastutil.ints.IntBinaryOperator_): number;
        abstract size(): number;
        putIfAbsent(arg0: K, arg1: number): number;
        abstract hashCode(): number;
        abstract putAll(arg0: Internal.Map_<K, number>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        abstract defaultReturnValue(arg0: number): void;
        abstract object2IntEntrySet(): Internal.ObjectSet<Internal.Object2IntMap$Entry<K>>;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2IntFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        /**
         * @deprecated
        */
        replace(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        merge(arg0: any, arg1: any, arg2: Internal.BiFunction_<any, any, any>): any;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, number, number>): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2IntFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        abstract equals(arg0: any): boolean;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, number>): number;
        forEach(arg0: Internal.BiConsumer_<K, number>): void;
        get empty(): boolean
    }
    type Object2IntMap_<K> = Object2IntMap<K>;
    interface CrossbowAttackMob extends Internal.RangedAttackMob {
        abstract getTarget(): Internal.LivingEntity;
        abstract shootCrossbowProjectile(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: Internal.Projectile_, arg3: number): void;
        shootCrossbowProjectile($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_, $$2: Internal.Projectile_, $$3: number, $$4: number): void;
        performCrossbowAttack($$0: Internal.LivingEntity_, $$1: number): void;
        abstract setChargingCrossbow(arg0: boolean): void;
        getProjectileShotVector($$0: Internal.LivingEntity_, $$1: Vec3d_, $$2: number): Vec3f;
        abstract onCrossbowAttackPerformed(): void;
        abstract performRangedAttack(arg0: Internal.LivingEntity_, arg1: number): void;
        get target(): Internal.LivingEntity
        set chargingCrossbow(arg0: boolean)
    }
    type CrossbowAttackMob_ = CrossbowAttackMob;
    class PaintEventJS extends Internal.ClientEventJS {
        constructor(m: Internal.Minecraft_, g: Internal.GuiGraphics_, d: number, s: Internal.Screen_)
        vertex(m: Matrix4f_, x: number, y: number, z: number, col: number, u: number, v: number): void;
        setShaderTexture(tex: ResourceLocation_): void;
        blend(enabled: boolean): void;
        setPositionColorShader(): void;
        getMatrix(): Matrix4f;
        translate(x: number, y: number, z: number): void;
        begin(type: Internal.VertexFormat$Mode_, format: Internal.VertexFormat_): void;
        beginQuads(format: Internal.VertexFormat_): void;
        bindTextureForSetup(tex: ResourceLocation_): void;
        pop(): void;
        getEntity(): Internal.Entity;
        multiply(q: Quaternionf_): void;
        end(): void;
        push(): void;
        vertex(m: Matrix4f_, x: number, y: number, z: number, col: number): void;
        setPositionColorTextureShader(): void;
        setShaderInstance(shader: Internal.Supplier_<Internal.ShaderInstance>): void;
        beginQuads(texture: boolean): void;
        multiplyWithMatrix(m: Matrix4f_): void;
        setShaderColor(r: number, g: number, b: number, a: number): void;
        scale(x: number, y: number, z: number): void;
        resetShaderColor(): void;
        set shaderTexture(tex: ResourceLocation_)
        get matrix(): Matrix4f
        get entity(): Internal.Entity
        set shaderInstance(shader: Internal.Supplier_<Internal.ShaderInstance>)
        readonly buffer: Internal.BufferBuilder;
        readonly matrices: Internal.PoseStack;
        readonly delta: number;
        readonly font: net.minecraft.client.gui.Font;
        readonly tesselator: Internal.Tesselator;
        readonly screen: Internal.Screen;
        readonly graphics: Internal.GuiGraphics;
        readonly mc: Internal.Minecraft;
    }
    type PaintEventJS_ = PaintEventJS;
    class DeployerBlockEntity extends Internal.KineticBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getRecipe(stack: Internal.ItemStack_): Internal.Recipe<net.minecraft.world.Container>;
        getHandOffset(partialTicks: number): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        changeMode(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getPlayer(): Internal.DeployerFakePlayer;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        startFistBump(facing: Internal.Direction_): boolean;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        getHandPose(): Internal.PartialModel;
        getOverflowItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        triggerFistBump(): void;
        redstoneUpdate(): void;
        setAnimatedOffset(offset: number): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        discardPlayer(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get player(): Internal.DeployerFakePlayer
        get handPose(): Internal.PartialModel
        get overflowItems(): Internal.List<Internal.ItemStack>
        set animatedOffset(offset: number)
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        snapshotParticipant: Internal.SnapshotParticipant<Internal.List<Internal.ItemStack>>;
        processingBehaviour: Internal.BeltProcessingBehaviour;
    }
    type DeployerBlockEntity_ = DeployerBlockEntity;
    class ParticleEngine implements Internal.ParticleEngineAccessor, io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor.ParticleEngineAccessor, Internal.PhasedParticleEngine, Internal.PreparableReloadListener, io.github.tropheusj.dripstone_fluid_lib.mixin.ParticleManagerAccessor, Internal.ParticleManagerAccessor {
        constructor($$0: Internal.ClientLevel_, $$1: Internal.TextureManager_)
        setParticleRenderingPhase(phase: Internal.ParticleRenderingPhase_): void;
        createTrackingEmitter($$0: Internal.Entity_, $$1: Internal.ParticleOptions_): void;
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource$BufferSource_, $$2: Internal.LightTexture_, $$3: Internal.Camera_, $$4: number): void;
        destroy($$0: BlockPos_, $$1: Internal.BlockState_): void;
        createParticle($$0: Internal.ParticleOptions_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number): Internal.Particle;
        getSpriteAwareFactories(): Internal.Map<any, any>;
        "handler$hgj000$sodium-extra$addBlockBreakParticles"(pos: BlockPos_, state: Internal.BlockState_, ci: Internal.CallbackInfo_): void;
        static setRENDER_ORDER(value: Internal.List_<Internal.ParticleRenderType>): void;
        callRegisterBlockLeakFactory(arg0: Internal.ParticleType_<any>, arg1: Internal.ParticleProvider$Sprite_<any>): void;
        add($$0: Internal.Particle_): void;
        createTrackingEmitter($$0: Internal.Entity_, $$1: Internal.ParticleOptions_, $$2: number): void;
        "handler$hgj000$sodium-extra$addParticle"(parameters: Internal.ParticleOptions_, x: number, y: number, z: number, velocityX: number, velocityY: number, velocityZ: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        getName(): string;
        static getRENDER_ORDER(): Internal.List<Internal.ParticleRenderType>;
        "handler$cjc000$fabric-registry-sync-v0$onInit"(world: Internal.ClientLevel_, textureManager: Internal.TextureManager_, info: Internal.CallbackInfo_): void;
        setLevel($$0: Internal.ClientLevel_): void;
        static getRENDER_ORDER$moonlight_$md$fca01f$4(): Internal.List<any>;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        countParticles(): string;
        "handler$hgj000$sodium-extra$addBlockBreakingParticles"(pos: BlockPos_, direction: Internal.Direction_, ci: Internal.CallbackInfo_): void;
        static setRENDER_ORDER$moonlight_$md$fca01f$3(arg0: Internal.List_<any>): void;
        crack($$0: BlockPos_, $$1: Internal.Direction_): void;
        tick(): void;
        getFactories(): Internal.Int2ObjectMap<any>;
        close(): void;
        getParticleAtlasTexture(): Internal.TextureAtlas;
        callRegisterFactory(arg0: Internal.ParticleType_<any>, arg1: Internal.ParticleEngine$SpriteParticleRegistration_<any>): void;
        port_lib$getProviders(): Internal.Int2ObjectMap<any>;
        set particleRenderingPhase(phase: Internal.ParticleRenderingPhase_)
        get spriteAwareFactories(): Internal.Map<any, any>
        set RENDER_ORDER(value: Internal.List_<Internal.ParticleRenderType>)
        get name(): string
        get RENDER_ORDER(): Internal.List<Internal.ParticleRenderType>
        set level($$0: Internal.ClientLevel_)
        get RENDER_ORDER$moonlight_$md$fca01f$4(): Internal.List<any>
        set RENDER_ORDER$moonlight_$md$fca01f$3(arg0: Internal.List_<any>)
        get factories(): Internal.Int2ObjectMap<any>
        get particleAtlasTexture(): Internal.TextureAtlas
        readonly textureAtlas: Internal.TextureAtlas;
    }
    type ParticleEngine_ = ParticleEngine;
    interface LightTextureAccessor {
        abstract getLightTexture(): Internal.DynamicTexture;
        get lightTexture(): Internal.DynamicTexture
        (): Internal.DynamicTexture_;
    }
    type LightTextureAccessor_ = LightTextureAccessor;
    class FluidParticleOptions extends Internal.Record implements Internal.ParticleOptions {
        constructor(fluid: Internal.FluidHolder_)
        fluid(): Internal.FluidHolder;
        getType(): Internal.ParticleType<any>;
        writeToString(): string;
        writeToNetwork(buffer: Internal.FriendlyByteBuf_): void;
        get type(): Internal.ParticleType<any>
        static readonly CODEC: Internal.Codec<Internal.FluidParticleOptions>;
        static readonly DESERIALIZER: Internal.ParticleOptions$Deserializer<Internal.FluidParticleOptions>;
    }
    type FluidParticleOptions_ = FluidParticleOptions;
    interface VertexSorting$DistanceFunction {
        abstract apply(arg0: Vec3f_): number;
        (arg0: Vec3f): number;
    }
    type VertexSorting$DistanceFunction_ = VertexSorting$DistanceFunction;
    class SpawnerBlock extends Internal.BaseEntityBlock implements Internal.CustomExpBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getExpDrop(state: Internal.BlockState_, world: Internal.LevelReader_, randomSource: Internal.RandomSource_, pos: BlockPos_, fortune: number, silktouch: number): number;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type SpawnerBlock_ = SpawnerBlock;
    interface Kind1 <F extends Internal.K1, Mu extends Internal.Kind1$Mu> extends Internal.App<Mu, F> {
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>): Internal.Products$P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>;
        group<T1, T2, T3, T4, T5, T6>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>): Internal.Products$P6<F, T1, T2, T3, T4, T5, T6>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>, arg13: Internal.App_<F, T14>, arg14: Internal.App_<F, T15>): Internal.Products$P15<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>;
        unbox<F extends Internal.K1, Proof extends Internal.Kind1$Mu>(arg0: Internal.App_<Proof, F>): Internal.Kind1<F, Proof>;
        group<T1, T2>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>): Internal.Products$P2<F, T1, T2>;
        group<T1, T2, T3, T4, T5, T6, T7, T8>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>): Internal.Products$P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>;
        group<T1, T2, T3, T4, T5, T6, T7>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>): Internal.Products$P13<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>): Internal.Products$P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9>;
        group<T1, T2, T3, T4>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>): Internal.Products$P4<F, T1, T2, T3, T4>;
        group<T1, T2, T3, T4, T5>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>): Internal.Products$P5<F, T1, T2, T3, T4, T5>;
        group<T1>(arg0: Internal.App_<F, T1>): Internal.Products$P1<F, T1>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>, arg13: Internal.App_<F, T14>): Internal.Products$P14<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>): Internal.Products$P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>;
        group<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>, arg13: Internal.App_<F, T14>, arg14: Internal.App_<F, T15>, arg15: Internal.App_<F, T16>): Internal.Products$P16<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>;
        group<T1, T2, T3>(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>): Internal.Products$P3<F, T1, T2, T3>;
    }
    type Kind1_<F extends Internal.K1, Mu extends Internal.Kind1$Mu> = Kind1<F, Mu>;
    class StrawBaleBlock extends Internal.HayBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getFlammability(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, face: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, face: Internal.Direction_): number;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type StrawBaleBlock_ = StrawBaleBlock;
    abstract class LivingEntity extends Internal.Entity implements Internal.LivingEntityExtensions, Internal.StarEntity, Internal.Attackable, Internal.BlockCachingEntity, net.blay09.mods.netherportalfix.mixin.LivingEntityAccessor, artifacts.mixin.accessors.LivingEntityAccessor, com.simibubi.create.foundation.mixin.accessor.LivingEntityAccessor, Internal.LivingEntityAccessor, Internal.EntityExtensions, net.darkhax.bookshelf.mixin.accessors.entity.AccessorLivingEntity, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LivingEntityAccessor, Internal.AccessorLivingEntity, dev.emi.trinkets.mixin.accessor.LivingEntityAccessor, Internal.IUranusDataEntity, earth.terrarium.adastra.mixins.common.LivingEntityAccessor, Internal.LivingEntityKJS, Internal.EquipmentEntity {
        getLastPos(): BlockPos;
        getDistance(pos: BlockPos_): number;
        isBlocking(): boolean;
        wrapOperation$hpl000$sophisticatedcore$addLandingEffects(level: Internal.ServerLevel_, type: Internal.ParticleOptions_, posX: number, posY: number, posZ: number, particleCount: number, xOffset: number, yOffset: number, zOffset: number, speed: number, original: Internal.Operation_<any>, state: Internal.BlockState_, pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getScale(): number;
        canAttack($$0: Internal.LivingEntity_): boolean;
        isSuppressingSlidingDownLadder(): boolean;
        getOffHandItem(): Internal.ItemStack;
        handler$geh000$porting_lib_entity$port_lib$attackEvent(source: DamageSource_, amount: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        isOnScoreboardTeam(teamId: string): boolean;
        startUsingItem($$0: Internal.InteractionHand_): void;
        getRandom(): Internal.RandomSource;
        invokePlayEquipmentBreakEffects(arg0: Internal.ItemStack_): void;
        static getEquipmentSlotForItem($$0: Internal.ItemStack_): Internal.EquipmentSlot;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        getArmorCoverPercentage(): number;
        handleRelativeFrictionAndCalculateMovement($$0: Vec3d_, $$1: number): Vec3d;
        getFallFlyingTicks(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        onLeaveCombat(): void;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        getAttributeValue($$0: Internal.Attribute_): number;
        method_5652($$0: Internal.CompoundTag_): void;
        static tickEntity(entity: Internal.Entity_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getSleepingPos(): Internal.Optional<BlockPos>;
        getNoActionTime(): number;
        damageHeldItem(): void;
        blockedByShield($$0: Internal.LivingEntity_): void;
        setMotionZ(z: number): void;
        wrapOperation$daf000$geckolib$allowLazyStackIdParity(remoteStack: Internal.ItemStack_, localStack: Internal.ItemStack_, original: Internal.Operation_<any>): boolean;
        attack(hp: number): void;
        handler$zcl000$porting_lib_base$port_lib$addEffect(newEffect: Internal.MobEffectInstance_, source: Internal.Entity_, cir: Internal.CallbackInfoReturnable_<any>, oldEffect: Internal.MobEffectInstance_): void;
        wrapOperation$hpl000$sophisticatedcore$addLandingEffects$mixinextras$bridge$491(level: Internal.ServerLevel_, type: Internal.ParticleOptions_, posX: number, posY: number, posZ: number, particleCount: number, xOffset: number, yOffset: number, zOffset: number, speed: number, original: Internal.Operation_<any>, state: Internal.LocalRef_<any>, pos: Internal.LocalRef_<any>): number;
        setItemInHand($$0: Internal.InteractionHand_, $$1: Internal.ItemStack_): void;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        getAttributes(): Internal.AttributeMap;
        getLastHurtByMob(): this;
        handler$hii000$star$swim(ci: Internal.CallbackInfo_): void;
        setMainHandItem(item: Internal.ItemStack_): void;
        removeEffectNoUpdate($$0: Internal.MobEffect_): Internal.MobEffectInstance;
        getHealth(): number;
        getMaxHealth(): number;
        getAttackAnim($$0: number): number;
        hex$setLastHurt(arg0: number): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getCurrentSwingDuration(): number;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        releaseUsingItem(): void;
        abstract getItemBySlot(arg0: Internal.EquipmentSlot_): Internal.ItemStack;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setRecordPlayingNearby($$0: BlockPos_, $$1: boolean): void;
        hasItemInSlot($$0: Internal.EquipmentSlot_): boolean;
        swing($$0: Internal.InteractionHand_): void;
        hasEffect($$0: Internal.MobEffect_): boolean;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        stopSleeping(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        static createLivingAttributes(): Internal.AttributeSupplier$Builder;
        getLocalBoundsForPose($$0: Internal.Pose_): Internal.AABB;
        isAmbientCreature(): boolean;
        stopUsingItem(): void;
        isSleeping(): boolean;
        onItemPickup($$0: Internal.ItemEntity_): void;
        isFallFlying(): boolean;
        hex$setLastDamageSource(arg0: DamageSource_): void;
        getFluidFallingAdjustedMovement($$0: number, $$1: boolean, $$2: Vec3d_): Vec3d;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        randomTeleport($$0: number, $$1: number, $$2: number, $$3: boolean): boolean;
        getName(): net.minecraft.network.chat.Component;
        getEffect($$0: Internal.MobEffect_): Internal.MobEffectInstance;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        getDismountPoses(): Internal.ImmutableList<Internal.Pose>;
        getLastHurtMobTimestamp(): number;
        setHealth($$0: number): void;
        isHolding($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        lithiumOnEquipmentChanged(): void;
        handler$hii000$star$fall(heightDifference: number, onGround: boolean, landedState: Internal.BlockState_, landedPosition: BlockPos_, ci: Internal.CallbackInfo_): void;
        getSpeed(): number;
        getArmorValue(): number;
        setDiscardFriction($$0: boolean): void;
        port_lib$onEffectRemoved(arg0: Internal.MobEffectInstance_): void;
        getKillCredit(): this;
        port_lib$isJumping(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        swing($$0: Internal.InteractionHand_, $$1: boolean): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getUsedItemHand(): Internal.InteractionHand;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        handler$dbd000$gravestones$spawnGravestone(source: DamageSource_, ci: Internal.CallbackInfo_): void;
        canAttackType($$0: Internal.EntityType_<any>): boolean;
        hex$setLastDamageStamp(arg0: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        getBrain(): Internal.Brain<any>;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        canBeSeenAsEnemy(): boolean;
        onEnterCombat(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getActiveEffects(): Internal.Collection<Internal.MobEffectInstance>;
        hurtArmor($$0: DamageSource_, $$1: number): void;
        canAttack($$0: Internal.LivingEntity_, $$1: Internal.TargetingConditions_): boolean;
        isAutoSpinAttack(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setUranusEntityData(nbt: Internal.CompoundTag_): void;
        getAttributeValue($$0: Internal.Holder_<Internal.Attribute>): number;
        getScriptType(): Internal.ScriptType;
        static resetForwardDirectionOfRelativePortalPosition($$0: Vec3d_): Vec3d;
        port_lib$getDeathSound(): Internal.SoundEvent;
        shouldDiscardFriction(): boolean;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        isHolding($$0: Internal.Item_): boolean;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        handler$hii000$star$fluidMovement(movementInput: Vec3d_, ci: Internal.CallbackInfo_, gravity: number, falling: boolean): void;
        isUsingItem(): boolean;
        static areAllEffectsAmbient($$0: Internal.Collection_<Internal.MobEffectInstance>): boolean;
        doHurtTarget($$0: Internal.Entity_): boolean;
        wrapOperation$bcp000$artifacts$travel(block: Internal.Block_, original: Internal.Operation_<any>): number;
        create$callSpawnItemParticles(arg0: Internal.ItemStack_, arg1: number): void;
        handler$zcl000$porting_lib_base$port_lib$onUsingTick(ci: Internal.CallbackInfo_): void;
        handler$zia000$ad_astra$adastra$tick(ci: Internal.CallbackInfo_): void;
        getVoicePitch(): number;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        "handler$edl000$lib39-phantom$lib39Phantom$tick"(ci: Internal.CallbackInfo_): void;
        skipDropExperience(): void;
        setSleepingPos($$0: BlockPos_): void;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttributeBaseValue($$0: Internal.Attribute_): number;
        sendEffectToPassengers($$0: Internal.MobEffectInstance_): void;
        getLastHurtByPlayer(): Internal.Player;
        "localvar$edl000$lib39-phantom$lib39Phantom$modifyDamageSource"(src: DamageSource_): DamageSource;
        handler$bcc001$artifacts$tick(ci: Internal.CallbackInfo_): void;
        getProjectile($$0: Internal.ItemStack_): Internal.ItemStack;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        isAffectedByPotions(): boolean;
        knockback($$0: number, $$1: number, $$2: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setAbsorptionAmount($$0: number): void;
        isTouchingUpsideDownFluid(): boolean;
        port_lib$spawnItemParticles(arg0: Internal.ItemStack_, arg1: number): void;
        getVisibilityPercent($$0: Internal.Entity_): number;
        handler$hkm000$uranus$onEntityFall(fallDistance: number, multiplier: number, source: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        artifacts$getPocketPistonLength(): number;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        startSleeping($$0: BlockPos_): void;
        swing(): void;
        setRange(change_range: boolean, level: number, currentEntity: Internal.LivingEntity_): void;
        getUseItem(): Internal.ItemStack;
        bookshelf$getDrinkingSound(arg0: Internal.ItemStack_): Internal.SoundEvent;
        isBaby(): boolean;
        handler$geh000$porting_lib_entity$port_lib$onFinishUsing(ci: Internal.CallbackInfo_, hand: Internal.InteractionHand_, result: Internal.ItemStack_): void;
        getSwimAmount($$0: number): number;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        getLastAttacker(): this;
        canBreatheUnderwater(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        die($$0: DamageSource_): void;
        setJumping($$0: boolean): void;
        getCustomData(): Internal.CompoundTag;
        removeAllEffects(): boolean;
        hasLineOfSight($$0: Internal.Entity_): boolean;
        hex$getLastHurt(): number;
        handler$zzb000$porting_lib_attributes$port_lib$entityGravity(travelVector: Vec3d_, ci: Internal.CallbackInfo_): void;
        onClimbable(): boolean;
        handler$zia000$ad_astra$adastra$hurt(source: DamageSource_, amount: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        getAbsorptionAmount(): number;
        onEffectRemoved($$0: Internal.MobEffectInstance_): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getMobType(): Internal.MobType;
        handler$zcl000$porting_lib_base$port_lib$canBeAffected(effect: Internal.MobEffectInstance_, cir: Internal.CallbackInfoReturnable_<any>): void;
        travel($$0: Vec3d_): void;
        addEffect($$0: Internal.MobEffectInstance_): boolean;
        handler$zia000$ad_astra$adastra$travel(travelVector: Vec3d_, ci: Internal.CallbackInfo_): void;
        getItemInHand($$0: Internal.InteractionHand_): Internal.ItemStack;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        handler$geh000$porting_lib_entity$onJump(ci: Internal.CallbackInfo_): void;
        getTeamId(): string;
        setStingerCount($$0: number): void;
        canRiderInteract(): boolean;
        method_5749($$0: Internal.CompoundTag_): void;
        hurtHelmet($$0: DamageSource_, $$1: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        hurtCurrentlyUsedShield($$0: number): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getLootTableSeed(): number;
        canSpawnSoulSpeedParticle(): boolean;
        canTakeItem($$0: Internal.ItemStack_): boolean;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        hex$playHurtSound(arg0: DamageSource_): void;
        shouldDropExperience(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        aiStep(): void;
        bookshelf$getFallDamageSound(arg0: number): Internal.SoundEvent;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getTicksUsingItem(): number;
        getLootTable(): ResourceLocation;
        setLastHurtByPlayer($$0: Internal.Player_): void;
        getArrowCount(): number;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        broadcastBreakEvent($$0: Internal.InteractionHand_): void;
        getLastHurtByPlayerTime(): number;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        wasExperienceConsumed(): boolean;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getStingerCount(): number;
        getDefaultMovementSpeed(): number;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getFallSounds(): Internal.LivingEntity$Fallsounds;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        getUseItemRemainingTicks(): number;
        localvar$geh000$porting_lib_entity$port_lib$modifyMultiplier(multiplier: number): number;
        addEffect($$0: Internal.MobEffectInstance_, $$1: Internal.Entity_): boolean;
        setRotation(yaw: number, pitch: number): void;
        attackable(): boolean;
        isDynamicLightEnabled(): boolean;
        getLastHurtByMobTimestamp(): number;
        isMonster(): boolean;
        getLastClimbablePos(): Internal.Optional<BlockPos>;
        getEatingSound($$0: Internal.ItemStack_): Internal.SoundEvent;
        abstract getMainArm(): Internal.HumanoidArm;
        calculateEntityAnimation($$0: boolean): void;
        getType(): string;
        forceAddEffect($$0: Internal.MobEffectInstance_, $$1: Internal.Entity_): void;
        isDamageSourceBlocked($$0: DamageSource_): boolean;
        getJumpBoostPower(): number;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getHurtDir(): number;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getActiveEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        bookshelf$getHurtSound(arg0: DamageSource_): Internal.SoundEvent;
        getOffhandItem(): Internal.ItemStack;
        onEquipItem($$0: Internal.EquipmentSlot_, $$1: Internal.ItemStack_, $$2: Internal.ItemStack_): void;
        getPassengers(): Internal.EntityArrayList;
        handler$zkk000$ae2$onClimbable(cri: Internal.CallbackInfoReturnable_<any>): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        callGetBaseMovementSpeedMultiplier(): number;
        isSensitiveToWater(): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        clearSleepingPos(): void;
        localvar$zcl000$porting_lib_base$port_lib$setSlipperiness(p: number): number;
        hex$checkTotemDeathProtection(arg0: DamageSource_): boolean;
        canDisableShield(): boolean;
        getFeetArmorItem(): Internal.ItemStack;
        getLastHurtMob(): this;
        getAttributeBaseValue($$0: Internal.Holder_<Internal.Attribute>): number;
        getServer(): Internal.MinecraftServer;
        getExperienceReward(): number;
        heal($$0: number): void;
        setMotionX(x: number): void;
        setLastHurtMob($$0: Internal.Entity_): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        setLastHurtByMob($$0: Internal.LivingEntity_): void;
        bookshelf$getDeathSound(): Internal.SoundEvent;
        setSpeed($$0: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getCombatTracker(): Internal.CombatTracker;
        getLastDamageSource(): DamageSource;
        canStandOnFluid($$0: Internal.FluidState_): boolean;
        isJumping(): boolean;
        setNoActionTime($$0: number): void;
        setMovementSpeedAddition(speed: number): void;
        equipmentHasChanged($$0: Internal.ItemStack_, $$1: Internal.ItemStack_): boolean;
        handler$geh000$porting_lib_entity$port_lib$cancelFall(fallDistance: number, multiplier: number, source: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        getAttribute($$0: Internal.Attribute_): Internal.AttributeInstance;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        canBeAffected($$0: Internal.MobEffectInstance_): boolean;
        getChestArmorItem(): Internal.ItemStack;
        setArrowCount($$0: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        port_lib$lastPos(): BlockPos;
        localvar$geh000$porting_lib_entity$port_lib$modifyDistance(fallDistance: number): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        isInvertedHealAndHarm(): boolean;
        modifyExpressionValue$zcl000$porting_lib_base$port_lib$canContinueUsing(original: boolean): boolean;
        setZ(z: number): void;
        getBedOrientation(): Internal.Direction;
        hex$getSoundVolume(): number;
        removeEffect($$0: Internal.MobEffect_): boolean;
        getDistanceSq(pos: BlockPos_): number;
        indicateDamage($$0: number, $$1: number): void;
        canBeSeenByAnyone(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        eat($$0: Internal.Level_, $$1: Internal.ItemStack_): Internal.ItemStack;
        getProfile(): Internal.GameProfile;
        getUranusEntityData(): Internal.CompoundTag;
        bookshelf$makePoofParticles(): void;
        isDeadOrDying(): boolean;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        take($$0: Internal.Entity_, $$1: number): void;
        runCommand(command: string): number;
        hex$getDeathSound(): Internal.SoundEvent;
        broadcastBreakEvent($$0: Internal.EquipmentSlot_): void;
        get lastPos(): BlockPos
        get blocking(): boolean
        set defaultMovementSpeedMultiplier(speed: number)
        get scale(): number
        get suppressingSlidingDownLadder(): boolean
        get offHandItem(): Internal.ItemStack
        get random(): Internal.RandomSource
        get armorCoverPercentage(): number
        get fallFlyingTicks(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get totalMovementSpeed(): number
        get sleepingPos(): Internal.Optional<BlockPos>
        get noActionTime(): number
        set motionZ(z: number)
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get attributes(): Internal.AttributeMap
        get lastHurtByMob(): Internal.LivingEntity
        set mainHandItem(item: Internal.ItemStack_)
        get health(): number
        get maxHealth(): number
        get item(): Internal.ItemStack
        set x(x: number)
        get currentSwingDuration(): number
        get undead(): boolean
        get ambientCreature(): boolean
        get sleeping(): boolean
        get fallFlying(): boolean
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get name(): net.minecraft.network.chat.Component
        set totalMovementSpeedMultiplier(speed: number)
        get dismountPoses(): Internal.ImmutableList<Internal.Pose>
        get lastHurtMobTimestamp(): number
        set health($$0: number)
        get speed(): number
        get armorValue(): number
        set discardFriction($$0: boolean)
        get killCredit(): Internal.LivingEntity
        get usedItemHand(): Internal.InteractionHand
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get brain(): Internal.Brain<any>
        get activeEffects(): Internal.Collection<Internal.MobEffectInstance>
        get autoSpinAttack(): boolean
        set uranusEntityData(nbt: Internal.CompoundTag_)
        get scriptType(): Internal.ScriptType
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get usingItem(): boolean
        get voicePitch(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set sleepingPos($$0: BlockPos_)
        get lastHurtByPlayer(): Internal.Player
        get affectedByPotions(): boolean
        set absorptionAmount($$0: number)
        get touchingUpsideDownFluid(): boolean
        get useItem(): Internal.ItemStack
        get baby(): boolean
        get living(): boolean
        get lastAttacker(): Internal.LivingEntity
        set jumping($$0: boolean)
        get customData(): Internal.CompoundTag
        get absorptionAmount(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        get mobType(): Internal.MobType
        get teamId(): string
        set stingerCount($$0: number)
        get legsArmorItem(): Internal.ItemStack
        get lootTableSeed(): number
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get ticksUsingItem(): number
        get lootTable(): ResourceLocation
        set lastHurtByPlayer($$0: Internal.Player_)
        get arrowCount(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        get lastHurtByPlayerTime(): number
        set legsArmorItem(item: Internal.ItemStack_)
        get stingerCount(): number
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get fallSounds(): Internal.LivingEntity$Fallsounds
        get peacefulCreature(): boolean
        get useItemRemainingTicks(): number
        get dynamicLightEnabled(): boolean
        get lastHurtByMobTimestamp(): number
        get monster(): boolean
        get lastClimbablePos(): Internal.Optional<BlockPos>
        get mainArm(): Internal.HumanoidArm
        get type(): string
        get jumpBoostPower(): number
        set chestArmorItem(item: Internal.ItemStack_)
        get hurtDir(): number
        get touchingFluid(): Internal.FluidState
        get activeEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>
        get motionY(): number
        get offhandItem(): Internal.ItemStack
        get passengers(): Internal.EntityArrayList
        get sensitiveToWater(): boolean
        get feetArmorItem(): Internal.ItemStack
        get lastHurtMob(): Internal.LivingEntity
        get server(): Internal.MinecraftServer
        get experienceReward(): number
        set motionX(x: number)
        set lastHurtMob($$0: Internal.Entity_)
        set lastHurtByMob($$0: Internal.LivingEntity_)
        set speed($$0: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get combatTracker(): Internal.CombatTracker
        get lastDamageSource(): DamageSource
        get jumping(): boolean
        set noActionTime($$0: number)
        set movementSpeedAddition(speed: number)
        set dynamicLightEnabled(enabled: boolean)
        get chestArmorItem(): Internal.ItemStack
        set arrowCount($$0: number)
        get motionZ(): number
        get invertedHealAndHarm(): boolean
        set z(z: number)
        get bedOrientation(): Internal.Direction
        get profile(): Internal.GameProfile
        get uranusEntityData(): Internal.CompoundTag
        get deadOrDying(): boolean
        set headArmorItem(item: Internal.ItemStack_)
        static readonly DEATH_DURATION: 20;
        removeArrowTime: number;
        yBodyRotO: number;
        lastHurtByPlayerTime: number;
        swingingArm: Internal.InteractionHand;
        deathTime: number;
        hurtTime: number;
        lastHurtByPlayer: Internal.Player;
        yya: number;
        static readonly SWING_DURATION: 6;
        attackAnim: number;
        static readonly ARMOR_SLOT_OFFSET: 100;
        lastHurt: number;
        static readonly PLAYER_HURT_EXPERIENCE_TIME: 100;
        readonly timeOffs: number;
        static readonly DEFAULT_BASE_GRAVITY: 0.08;
        oAttackAnim: number;
        yBodyRot: number;
        yHeadRot: number;
        yHeadRotO: number;
        swinging: boolean;
        static readonly HAND_SLOTS: 2;
        static readonly ARMOR_SLOTS: 4;
        swingTime: number;
        removeStingerTime: number;
        dead: boolean;
        static readonly USE_ITEM_INTERVAL: 4;
        readonly walkAnimation: Internal.WalkAnimationState;
        static readonly MIN_MOVEMENT_DISTANCE: 0.003;
        hurtDuration: number;
        readonly invulnerableDuration: number;
        zza: number;
        xxa: number;
        readonly rotA: number;
        effectsDirty: boolean;
        static readonly EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT: 0.5;
        static readonly EQUIPMENT_SLOT_OFFSET: 98;
    }
    type LivingEntity_ = LivingEntity;
    interface BlockSpoutingBehaviour {
        abstract fillBlock(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.SpoutBlockEntity_, arg3: Internal.FluidStack_, arg4: boolean): number;
        get(level: Internal.Level_, pos: BlockPos_): this;
        (arg0: Internal.Level, arg1: BlockPos, arg2: Internal.SpoutBlockEntity, arg3: Internal.FluidStack, arg4: boolean): number;
        readonly BY_BLOCK_ENTITY: Internal.SimpleRegistry<Internal.BlockEntityType<any>, Internal.BlockSpoutingBehaviour>;
        readonly BY_BLOCK: Internal.SimpleRegistry<Internal.Block, Internal.BlockSpoutingBehaviour>;
    }
    type BlockSpoutingBehaviour_ = BlockSpoutingBehaviour;
    class SaddleItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SaddleItem_ = SaddleItem;
    class ListPoolElement extends Internal.StructurePoolElement {
        constructor($$0: Internal.List_<Internal.StructurePoolElement>, $$1: Internal.StructureTemplatePool$Projection_)
        static readonly CODEC: Internal.Codec<Internal.ListPoolElement>;
    }
    type ListPoolElement_ = ListPoolElement;
    class TippedArrowItem extends Internal.ArrowItem {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TippedArrowItem_ = TippedArrowItem;
    class PostboxBlockEntity extends Internal.PackagePortBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        spawnParticles(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        shouldCloseCurrentScreen(): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        trackedGlobalStation: Internal.WeakReference<Internal.GlobalStation>;
        computerBehaviour: Internal.AbstractComputerBehaviour;
        flag: Internal.LerpedFloat;
        forceFlag: boolean;
    }
    type PostboxBlockEntity_ = PostboxBlockEntity;
    interface MobEffectInstanceExtensions {
        addCurativeItem(stack: Internal.ItemStack_): void;
        abstract setCurativeItems(arg0: Internal.List_<Internal.ItemStack>): void;
        abstract getCurativeItems(): Internal.List<Internal.ItemStack>;
        writeCurativeItems(nbt: Internal.CompoundTag_): void;
        isCurativeItem(stack: Internal.ItemStack_): boolean;
        set curativeItems(arg0: Internal.List_<Internal.ItemStack>)
        get curativeItems(): Internal.List<Internal.ItemStack>
    }
    type MobEffectInstanceExtensions_ = MobEffectInstanceExtensions;
    class BlockBurntTorchWall extends Internal.WallTorchBlock implements Internal.IDreadBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockBurntTorchWall_ = BlockBurntTorchWall;
    class ClipboardBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        onEditedBy(player: Internal.Player_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        updateWrittenState(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        dataContainer: Internal.ItemStack;
    }
    type ClipboardBlockEntity_ = ClipboardBlockEntity;
    class DragonStrafePlayerPhase extends Internal.AbstractDragonPhaseInstance {
        constructor($$0: Internal.EnderDragon_)
        setTarget($$0: Internal.LivingEntity_): void;
        getPhase(): Internal.EnderDragonPhase<Internal.DragonStrafePlayerPhase>;
        set target($$0: Internal.LivingEntity_)
        get phase(): Internal.EnderDragonPhase<Internal.DragonStrafePlayerPhase>
    }
    type DragonStrafePlayerPhase_ = DragonStrafePlayerPhase;
    class KeyboardBlock extends Internal.BaseEntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        openScreen(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static rotateShape(from: Internal.Direction_, to: Internal.Direction_, shape: Internal.VoxelShape_): Internal.VoxelShape;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getKBTile(world: Internal.Level_, pos: BlockPos_): Internal.KeyboardTile;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getKeyCaps(view: Internal.BlockGetter_, pos: BlockPos_): Internal.KeyCaps;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type KeyboardBlock_ = KeyboardBlock;
    class CreativeSlotItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        static getSlot(stack: Internal.ItemStack_): Internal.SlotType;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        fillItemCategory(items: Internal.FabricItemGroupEntries_): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static withSlot(stack: Internal.ItemStack_, type: Internal.SlotType_): Internal.ItemStack;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CreativeSlotItem_ = CreativeSlotItem;
    interface CycleButton$ValueListSupplier <T> {
        create<T>($$0: Internal.BooleanSupplier_, $$1: Internal.List_<T>, $$2: Internal.List_<T>): this;
        abstract getSelectedList(): Internal.List<T>;
        abstract getDefaultList(): Internal.List<T>;
        create<T>($$0: Internal.Collection_<T>): this;
        get selectedList(): Internal.List<T>
        get defaultList(): Internal.List<T>
    }
    type CycleButton$ValueListSupplier_<T> = CycleButton$ValueListSupplier<T>;
    interface ChannelPromise extends Internal.Promise<void>, Internal.ChannelFuture {
        abstract isSuccess(): boolean;
        abstract addListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>[]): this;
        abstract addListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>): this;
        abstract trySuccess(): boolean;
        abstract tryFailure(arg0: Internal.Throwable_): boolean;
        abstract awaitUninterruptibly(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract getNow(): void;
        abstract cause(): Internal.Throwable;
        abstract isVoid(): boolean;
        abstract sync(): this;
        abstract await(): this;
        abstract await(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract awaitUninterruptibly(): this;
        abstract await(arg0: number): boolean;
        abstract removeListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>[]): this;
        abstract setFailure(arg0: Internal.Throwable_): this;
        abstract setUncancellable(): boolean;
        exceptionNow(): Internal.Throwable;
        abstract setSuccess(): this;
        abstract awaitUninterruptibly(arg0: number): boolean;
        abstract get(arg0: number, arg1: Internal.TimeUnit_): void;
        abstract isCancelled(): boolean;
        abstract unvoid(): this;
        state(): Internal.Future$State;
        abstract removeListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<void>>): this;
        abstract trySuccess(arg0: void): boolean;
        abstract setSuccess(arg0: void): Internal.Promise<void>;
        abstract setSuccess(arg0: void): this;
        resultNow(): void;
        abstract isDone(): boolean;
        abstract cancel(arg0: boolean): boolean;
        abstract channel(): io.netty.channel.Channel;
        abstract syncUninterruptibly(): this;
        abstract isCancellable(): boolean;
        abstract get(): void;
        get success(): boolean
        get now(): void
        get "void"(): boolean
        set failure(arg0: Internal.Throwable_)
        get cancelled(): boolean
        set success(arg0: void)
        set success(arg0: void)
        get done(): boolean
        get cancellable(): boolean
    }
    type ChannelPromise_ = ChannelPromise;
    class RichSoilFarmlandBlock extends Internal.FarmBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        isFertile(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        static turnToRichSoil(entity: Internal.Entity_, state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_): void;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type RichSoilFarmlandBlock_ = RichSoilFarmlandBlock;
    class AfterRecipesLoadedEventJS extends Internal.EventJS {
        constructor(r: Internal.Map_<Internal.RecipeType<any>, Internal.Map<ResourceLocation, Internal.Recipe<any>>>, n: Internal.Map_<ResourceLocation, Internal.Recipe<any>>)
        countRecipes(filter: Internal.RecipeFilter_): number;
        remove(filter: Internal.RecipeFilter_): number;
        forEachRecipe(filter: Internal.RecipeFilter_, consumer: Internal.Consumer_<Internal.RecipeKJS>): void;
    }
    type AfterRecipesLoadedEventJS_ = AfterRecipesLoadedEventJS;
    interface IStackableContentsUpgrade {
        abstract getMinimumMultiplierRequired(): number;
        get minimumMultiplierRequired(): number
        (): number;
    }
    type IStackableContentsUpgrade_ = IStackableContentsUpgrade;
    interface MethodHandleInfo {
        isVarArgs(): boolean;
        abstract getMethodType(): Internal.MethodType;
        toString(arg0: number, arg1: typeof any, arg2: string, arg3: Internal.MethodType_): string;
        abstract getModifiers(): number;
        abstract getName(): string;
        abstract getReferenceKind(): number;
        referenceKindToString(arg0: number): string;
        abstract getDeclaringClass(): typeof any;
        abstract reflectAs<T extends Internal.Member>(arg0: T, arg1: Internal.MethodHandles$Lookup_): T;
        get varArgs(): boolean
        get methodType(): Internal.MethodType
        get modifiers(): number
        get name(): string
        get referenceKind(): number
        get declaringClass(): typeof any
        readonly REF_getStatic: 2;
        readonly REF_newInvokeSpecial: 8;
        readonly REF_invokeVirtual: 5;
        readonly REF_putField: 3;
        readonly REF_invokeSpecial: 7;
        readonly REF_invokeInterface: 9;
        readonly REF_putStatic: 4;
        readonly REF_getField: 1;
        readonly REF_invokeStatic: 6;
    }
    type MethodHandleInfo_ = MethodHandleInfo;
    class BlockAkashicLeaves extends Internal.LeavesBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        isFlammable(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getFlammability(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockAkashicLeaves_ = BlockAkashicLeaves;
    interface ICookingUpgrade <T extends Internal.AbstractCookingRecipe> {
        abstract getCookingLogic(): Internal.CookingLogic<T>;
        get cookingLogic(): Internal.CookingLogic<T>
        (): Internal.CookingLogic_<T>;
        readonly UPGRADE_GROUP: Internal.UpgradeGroup;
    }
    type ICookingUpgrade_<T extends Internal.AbstractCookingRecipe> = ICookingUpgrade<T>;
    class LightTexture implements Internal.LightTextureAccessor, Internal.AutoCloseable {
        constructor($$0: Internal.GameRenderer_, $$1: Internal.Minecraft_)
        static pack($$0: number, $$1: number): number;
        static block($$0: number): number;
        turnOffLightLayer(): void;
        close(): void;
        static sky($$0: number): number;
        getLightTexture(): Internal.DynamicTexture;
        static getBrightness($$0: Internal.DimensionType_, $$1: number): number;
        updateLightTexture($$0: number): void;
        turnOnLightLayer(): void;
        tick(): void;
        get lightTexture(): Internal.DynamicTexture
        static readonly FULL_BRIGHT: 15728880;
        static readonly FULL_SKY: 15728640;
        static readonly FULL_BLOCK: 240;
    }
    type LightTexture_ = LightTexture;
    class FluidAttributes$Builder {
        density(density: number): this;
        build(fluid: Internal.Fluid_): Internal.FluidAttributes;
        viscosity(viscosity: number): this;
        overlay(texture: ResourceLocation_): this;
        translationKey(translationKey: string): this;
        temperature(temperature: number): this;
        sound(fillSound: Internal.SoundEvent_, emptySound: Internal.SoundEvent_): this;
        color(color: number): this;
        luminosity(luminosity: number): this;
        sound(sound: Internal.SoundEvent_): this;
        gaseous(): this;
        rarity(rarity: Internal.Rarity_): this;
    }
    type FluidAttributes$Builder_ = FluidAttributes$Builder;
    class IronPipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
        static readonly ENABLED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type IronPipeBlock_ = IronPipeBlock;
    abstract class DateFormat extends Internal.Format {
        static getDateInstance(arg0: number): Internal.DateFormat;
        static getTimeInstance(arg0: number, arg1: Internal.Locale_): Internal.DateFormat;
        static getTimeInstance(): Internal.DateFormat;
        setCalendar(arg0: Internal.Calendar_): void;
        format(arg0: Internal.Date_): string;
        static getDateInstance(): Internal.DateFormat;
        static getDateTimeInstance(): Internal.DateFormat;
        static getDateInstance(arg0: number, arg1: Internal.Locale_): Internal.DateFormat;
        static getDateTimeInstance(arg0: number, arg1: number, arg2: Internal.Locale_): Internal.DateFormat;
        getNumberFormat(): Internal.NumberFormat;
        static getInstance(): Internal.DateFormat;
        static getAvailableLocales(): Internal.Locale[];
        parse(arg0: string): Internal.Date;
        abstract parse(arg0: string, arg1: Internal.ParsePosition_): Internal.Date;
        getCalendar(): Internal.Calendar;
        static getDateTimeInstance(arg0: number, arg1: number): Internal.DateFormat;
        setNumberFormat(arg0: Internal.NumberFormat_): void;
        setTimeZone(arg0: Internal.TimeZone_): void;
        getTimeZone(): Internal.TimeZone;
        abstract format(arg0: Internal.Date_, arg1: Internal.StringBuffer_, arg2: Internal.FieldPosition_): Internal.StringBuffer;
        isLenient(): boolean;
        static getTimeInstance(arg0: number): Internal.DateFormat;
        setLenient(arg0: boolean): void;
        get timeInstance(): Internal.DateFormat
        set calendar(arg0: Internal.Calendar_)
        get dateInstance(): Internal.DateFormat
        get dateTimeInstance(): Internal.DateFormat
        get numberFormat(): Internal.NumberFormat
        get instance(): Internal.DateFormat
        get availableLocales(): Internal.Locale[]
        get calendar(): Internal.Calendar
        set numberFormat(arg0: Internal.NumberFormat_)
        set timeZone(arg0: Internal.TimeZone_)
        get timeZone(): Internal.TimeZone
        get lenient(): boolean
        set lenient(arg0: boolean)
        static readonly DEFAULT: 2;
        static readonly MONTH_FIELD: 2;
        static readonly WEEK_OF_MONTH_FIELD: 13;
        static readonly FULL: 0;
        static readonly MILLISECOND_FIELD: 8;
        static readonly LONG: 1;
        static readonly AM_PM_FIELD: 14;
        static readonly SHORT: 3;
        static readonly ERA_FIELD: 0;
        static readonly WEEK_OF_YEAR_FIELD: 12;
        static readonly YEAR_FIELD: 1;
        static readonly MINUTE_FIELD: 6;
        static readonly DATE_FIELD: 3;
        static readonly HOUR0_FIELD: 16;
        static readonly HOUR_OF_DAY1_FIELD: 4;
        static readonly HOUR_OF_DAY0_FIELD: 5;
        static readonly SECOND_FIELD: 7;
        static readonly DAY_OF_WEEK_FIELD: 9;
        static readonly TIMEZONE_FIELD: 17;
        static readonly MEDIUM: 2;
        static readonly DAY_OF_WEEK_IN_MONTH_FIELD: 11;
        static readonly HOUR1_FIELD: 15;
        static readonly DAY_OF_YEAR_FIELD: 10;
    }
    type DateFormat_ = DateFormat;
    class ModuleDescriptor$Opens implements Internal.Comparable<Internal.ModuleDescriptor$Opens> {
        modifiers(): Internal.Set<Internal.ModuleDescriptor$Opens$Modifier>;
        accessFlags(): Internal.Set<Internal.AccessFlag>;
        isQualified(): boolean;
        targets(): Internal.Set<string>;
        compareTo(arg0: Internal.ModuleDescriptor$Opens_): number;
        source(): string;
        compareTo(arg0: any): number;
        get qualified(): boolean
    }
    type ModuleDescriptor$Opens_ = ModuleDescriptor$Opens;
    /**
     * @deprecated
    */
    class PrimaryLevelData$SpecialWorldProperty extends Internal.Enum<Internal.PrimaryLevelData$SpecialWorldProperty> {
        static valueOf($$0: string): Internal.PrimaryLevelData$SpecialWorldProperty;
        static values(): Internal.PrimaryLevelData$SpecialWorldProperty[];
        static readonly FLAT: Internal.PrimaryLevelData$SpecialWorldProperty;
        static readonly DEBUG: Internal.PrimaryLevelData$SpecialWorldProperty;
        static readonly NONE: Internal.PrimaryLevelData$SpecialWorldProperty;
    }
    type PrimaryLevelData$SpecialWorldProperty_ = PrimaryLevelData$SpecialWorldProperty | "flat" | "debug" | "none";
    interface RequirementsStrategy {
        abstract createRequirements(arg0: Internal.Collection_<string>): string[][];
        (arg0: Internal.Collection<string>): string[][];
        readonly OR: Internal.RequirementsStrategy;
        readonly AND: Internal.RequirementsStrategy;
    }
    type RequirementsStrategy_ = RequirementsStrategy;
    class CraftingBookCategory extends Internal.Enum<Internal.CraftingBookCategory> implements Internal.StringRepresentable {
        static valueOf($$0: string): Internal.CraftingBookCategory;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.CraftingBookCategory[];
        get serializedName(): string
        static readonly REDSTONE: Internal.CraftingBookCategory;
        static readonly EQUIPMENT: Internal.CraftingBookCategory;
        static readonly MISC: Internal.CraftingBookCategory;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.CraftingBookCategory>;
        static readonly BUILDING: Internal.CraftingBookCategory;
    }
    type CraftingBookCategory_ = "equipment" | "misc" | "building" | "redstone" | CraftingBookCategory;
    abstract class TreeDecorator {
        constructor()
        abstract place(arg0: Internal.TreeDecorator$Context_): void;
        static readonly CODEC: Internal.Codec<Internal.TreeDecorator>;
    }
    type TreeDecorator_ = TreeDecorator;
    interface WritableMount extends Internal.Mount {
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        abstract openForWrite(arg0: string): Internal.SeekableByteChannel;
        isReadOnly(path: string): boolean;
        abstract makeDirectory(arg0: string): void;
        abstract openForRead(arg0: string): Internal.SeekableByteChannel;
        abstract "delete"(arg0: string): void;
        abstract rename(arg0: string, arg1: string): void;
        abstract isDirectory(arg0: string): boolean;
        abstract list(arg0: string, arg1: Internal.List_<string>): void;
        abstract getRemainingSpace(): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        abstract openForAppend(arg0: string): Internal.SeekableByteChannel;
        openFile(path: string, options: Internal.Set_<Internal.OpenOption>): Internal.SeekableByteChannel;
        abstract exists(arg0: string): boolean;
        abstract getCapacity(): number;
        abstract getSize(arg0: string): number;
        getAttributes(path: string): Internal.BasicFileAttributes;
        get remainingSpace(): number
        get capacity(): number
    }
    type WritableMount_ = WritableMount;
    class BarrelBlockEntity extends Internal.RandomizableContainerBlockEntity implements Internal.InventoryChangeTracker, Internal.LithiumInventory {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        setChanged(): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setInventoryLithium(arg0: Internal.NonNullList_<any>): void;
        handler$elg000$lithium$setInventoryStackListReplacement(list: Internal.NonNullList_<any>, ci: Internal.CallbackInfo_): void;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getInventoryLithium(): Internal.NonNullList<any>;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        recheckOpen(): void;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        set inventoryLithium(arg0: Internal.NonNullList_<any>)
        get inventoryLithium(): Internal.NonNullList<any>
        get width(): number
        get maxStackSize(): number
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        items: Internal.NonNullList<Internal.ItemStack>;
    }
    type BarrelBlockEntity_ = BarrelBlockEntity;
    class CapacitorItem extends owmii.powah.lib.item.ItemBase {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CapacitorItem_ = CapacitorItem;
    class StringArithmetic implements Internal.Arithmetic {
        getOperator(pattern: Internal.HexPattern_): Internal.Operator;
        opTypes(): Internal.Iterable<Internal.HexPattern>;
        arithName(): string;
        static readonly INSTANCE: Internal.StringArithmetic;
    }
    type StringArithmetic_ = StringArithmetic;
    interface AnchorOwner {
        abstract arsenal$setAnchor(arg0: Internal.InteractionHand_, arg1: Internal.AnchorbladeEntity_): void;
        abstract arsenal$isAnchorActive(arg0: Internal.InteractionHand_, arg1: boolean): boolean;
        abstract arsenal$getAnchor(arg0: Internal.InteractionHand_, arg1: boolean): Internal.AnchorbladeEntity;
    }
    type AnchorOwner_ = AnchorOwner;
    class NoCollisionCustomTrackBlock extends Internal.TrackBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, material: Internal.TrackMaterial_)
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_, defaultMaterial: Internal.TrackMaterial_): Internal.TrackMaterial;
        getNearestTrackAxis(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, lookVec: Vec3d_): net.createmod.catnip.data.Pair<Vec3d, Internal.Direction$AxisDirection>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isSlope(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getElevationAtCenter(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): number;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TrackBlockEntity>): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TrackBlockEntity>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TrackBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_): Internal.TrackMaterial;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static walkConnectedTracks(worldIn: Internal.BlockGetter_, location: Internal.TrackNodeLocation_, linear: boolean): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TrackBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static addToListIfConnected(fromEnd: Internal.TrackNodeLocation_, list: Internal.Collection_<Internal.TrackNodeLocation$DiscoveredLocation>, offsetFactory: Internal.BiFunction_<number, boolean, Vec3d>, normalFactory: Internal.Function_<boolean, Vec3d>, dimensionFactory: Internal.Function_<boolean, Internal.ResourceKey<Internal.Level>>, yOffsetFactory: Internal.Function_<Vec3d, number>, axis: Vec3d_, viaTurn: Internal.BezierConnection_, materialFactory: Internal.BiFunction_<boolean, Vec3d, Internal.TrackMaterial>): void;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type NoCollisionCustomTrackBlock_ = NoCollisionCustomTrackBlock;
    interface GameRulesBooleanRuleAccessor {
        invokeCreate(initialValue: boolean, changeCallback: Internal.BiConsumer_<Internal.MinecraftServer, Internal.GameRules$BooleanValue>): Internal.GameRules$Type<Internal.GameRules$BooleanValue>;
    }
    type GameRulesBooleanRuleAccessor_ = GameRulesBooleanRuleAccessor;
    class WorldTemplate extends Internal.ValueObject {
        constructor()
        static parse($$0: Internal.JsonObject_): Internal.WorldTemplate;
        name: string;
        version: string;
        image: string;
        id: string;
        recommendedPlayers: string;
        link: string;
        type: Internal.WorldTemplate$WorldTemplateType;
        author: string;
        trailer: string;
    }
    type WorldTemplate_ = WorldTemplate;
    interface IntBidirectionalIterator extends Internal.IntIterator, Internal.ObjectBidirectionalIterator<number> {
        forEachRemaining(arg0: any): void;
        abstract previousInt(): number;
        skip(arg0: number): number;
        /**
         * @deprecated
        */
        next(): any;
        /**
         * @deprecated
        */
        previous(): number;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        forEachRemaining(arg0: Internal.IntConsumer_): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        abstract hasPrevious(): boolean;
        remove(): void;
        back(arg0: number): number;
        abstract hasNext(): boolean;
        abstract nextInt(): number;
    }
    type IntBidirectionalIterator_ = IntBidirectionalIterator;
    interface IntListIterator extends Internal.ListIterator<number>, Internal.IntBidirectionalIterator {
        /**
         * @deprecated
        */
        add(arg0: any): void;
        abstract nextIndex(): number;
        forEachRemaining(arg0: any): void;
        abstract previousInt(): number;
        /**
         * @deprecated
        */
        next(): any;
        /**
         * @deprecated
        */
        set(arg0: any): void;
        set(arg0: number): void;
        skip(arg0: number): number;
        /**
         * @deprecated
        */
        add(arg0: number): void;
        add(arg0: number): void;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        forEachRemaining(arg0: Internal.IntConsumer_): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        set(arg0: number): void;
        remove(): void;
        abstract hasPrevious(): boolean;
        back(arg0: number): number;
        abstract hasNext(): boolean;
        /**
         * @deprecated
        */
        previous(): any;
        abstract nextInt(): number;
        abstract previousIndex(): number;
    }
    type IntListIterator_ = IntListIterator;
    interface PoolChunkMetric {
        abstract usage(): number;
        abstract chunkSize(): number;
        abstract freeBytes(): number;
    }
    type PoolChunkMetric_ = PoolChunkMetric;
    class DocGenerationEventJS extends Internal.EventJS {
        constructor()
        specialType(typeName: string, elements: Internal.List_<any>): this;
        addSnippet(name: string, items: Internal.List_<any>): this;
        getProperty(object: Internal.JsonObject_): Internal.AbstractProperty<any>;
        customSnippet(type: string, prefixes: Internal.List_<string>, body: Internal.List_<any>): this;
        getJavaClass(clazz: typeof any): Internal.DocumentClass;
        transformByName(clazz: string, transformer: Internal.Consumer_<Internal.DocumentClass>): this;
        transformDocument(clazz: typeof any, transformer: Internal.Consumer_<Internal.DocumentClass>): this;
        customSnippet(type: string, prefixes: Internal.List_<string>, body: Internal.List_<any>, desc: string): this;
        addSnippet(name: string, items: Internal.List_<any>, desc: string): this;
    }
    type DocGenerationEventJS_ = DocGenerationEventJS;
    interface LivingEntityKJS extends Internal.EntityKJS {
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        isUndead(): boolean;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setTotalMovementSpeedMultiplier(speed: number): void;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        attack(hp: number): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        setMaxHealth(hp: number): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        setZ(z: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        set defaultMovementSpeedMultiplier(speed: number)
        get ambientCreature(): boolean
        get monster(): boolean
        get offHandItem(): Internal.ItemStack
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set totalMovementSpeedMultiplier(speed: number)
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        set maxHealth(hp: number)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        readonly KJS_PLAYER_CUSTOM_SPEED: Internal.UUID;
        readonly KJS_PLAYER_CUSTOM_SPEED_NAME: "kubejs.player.speed.modifier";
    }
    type LivingEntityKJS_ = LivingEntityKJS;
    interface GeoAnimatable {
        abstract getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        getBoneResetTime(): number;
        abstract registerControllers(arg0: Internal.AnimatableManager$ControllerRegistrar_): void;
        shouldPlayAnimsWhileGamePaused(): boolean;
        abstract getTick(arg0: any): number;
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
        get boneResetTime(): number
    }
    type GeoAnimatable_ = GeoAnimatable;
    class Pattern implements Internal.Serializable {
        flags(): number;
        static compile(arg0: string, arg1: number): Internal.Pattern;
        split(arg0: Internal.CharSequence_, arg1: number): string[];
        matcher(arg0: Internal.CharSequence_): Internal.Matcher;
        asMatchPredicate(): Internal.Predicate<string>;
        static compile(arg0: string): Internal.Pattern;
        splitAsStream(arg0: Internal.CharSequence_): Internal.Stream<string>;
        asPredicate(): Internal.Predicate<string>;
        splitWithDelimiters(arg0: Internal.CharSequence_, arg1: number): string[];
        pattern(): string;
        namedGroups(): Internal.Map<string, number>;
        split(arg0: Internal.CharSequence_): string[];
        static matches(arg0: string, arg1: Internal.CharSequence_): boolean;
        static quote(arg0: string): string;
        static readonly CANON_EQ: 128;
        static readonly UNIX_LINES: 1;
        static readonly DOTALL: 32;
        static readonly UNICODE_CHARACTER_CLASS: 256;
        static readonly COMMENTS: 4;
        static readonly UNICODE_CASE: 64;
        static readonly CASE_INSENSITIVE: 2;
        static readonly MULTILINE: 8;
        static readonly LITERAL: 16;
    }
    type Pattern_ = Pattern;
    class StructureManager {
        constructor($$0: Internal.LevelAccessor_, $$1: Internal.WorldOptions_, $$2: any_)
        getStructureWithPieceAt($$0: BlockPos_, $$1: Internal.TagKey_<Internal.Structure>): Internal.StructureStart;
        shouldGenerateStructures(): boolean;
        getStructureWithPieceAt($$0: BlockPos_, $$1: Internal.ResourceKey_<Internal.Structure>): Internal.StructureStart;
        getStructureWithPieceAt($$0: BlockPos_, $$1: Internal.Structure_): Internal.StructureStart;
        setStartForStructure($$0: Internal.SectionPos_, $$1: Internal.Structure_, $$2: Internal.StructureStart_, $$3: Internal.StructureAccess_): void;
        registryAccess(): Internal.RegistryAccess;
        addReference($$0: Internal.StructureStart_): void;
        getStartForStructure($$0: Internal.SectionPos_, $$1: Internal.Structure_, $$2: Internal.StructureAccess_): Internal.StructureStart;
        fillStartsForStructure($$0: Internal.Structure_, $$1: Internal.LongSet_, $$2: Internal.Consumer_<Internal.StructureStart>): void;
        startsForStructure($$0: Internal.ChunkPos_, $$1: Internal.Predicate_<Internal.Structure>): Internal.List<Internal.StructureStart>;
        getAllStructuresAt($$0: BlockPos_): Internal.Map<Internal.Structure, Internal.LongSet>;
        getStructureAt($$0: BlockPos_, $$1: Internal.Structure_): Internal.StructureStart;
        hasAnyStructureAt($$0: BlockPos_): boolean;
        startsForStructure($$0: Internal.SectionPos_, $$1: Internal.Structure_): Internal.List<Internal.StructureStart>;
        structureHasPieceAt($$0: BlockPos_, $$1: Internal.StructureStart_): boolean;
        addReferenceForStructure($$0: Internal.SectionPos_, $$1: Internal.Structure_, $$2: number, $$3: Internal.StructureAccess_): void;
        checkStructurePresence($$0: Internal.ChunkPos_, $$1: Internal.Structure_, $$2: boolean): Internal.StructureCheckResult;
        forWorldGenRegion($$0: Internal.WorldGenRegion_): this;
    }
    type StructureManager_ = StructureManager;
    class ShapedKubeJSRecipe extends Internal.ShapedRecipe implements Internal.KubeJSCraftingRecipe {
        constructor(id: ResourceLocation_, group: string, category: Internal.CraftingBookCategory_, width: number, height: number, ingredients: Internal.NonNullList_<Internal.Ingredient>, result: Internal.ItemStack_, mirror: boolean, ingredientActions: Internal.List_<Internal.IngredientAction>, modifyResult: Internal.ModifyRecipeResultCallback_, stage: string)
        static bookshelf$dissolvePattern(pattern: string[], ingredients: Internal.Map_<string, Internal.Ingredient>, width: number, height: number): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        kjs$getStage(): string;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems(container: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        kjs$getModifyResult(): Internal.ModifyRecipeResultCallback;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        kjs$getRemainingItems(container: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        static bookshelf$shrink(...pattern: string[]): string[];
        static bookshelf$patternFromJson(json: Internal.JsonArray_): string[];
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static bookshelf$keyFromJson($$0: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        kjs$assemble(container: Internal.CraftingContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        kjs$getIngredientActions(): Internal.List<Internal.IngredientAction>;
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get mod(): string
    }
    type ShapedKubeJSRecipe_ = ShapedKubeJSRecipe;
    class Rectangle extends Internal.Rectangle2D implements Internal.Shape, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Point_, arg1: Internal.Dimension_)
        constructor(arg0: number, arg1: number)
        constructor(arg0: number, arg1: number, arg2: number, arg3: number)
        constructor(arg0: Internal.Rectangle_)
        constructor(arg0: Internal.Dimension_)
        constructor(arg0: Internal.Point_)
        contains(arg0: Internal.Point_): boolean;
        setSize(arg0: number, arg1: number): void;
        contains(arg0: Internal.Rectangle_): boolean;
        contains(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        grow(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        inside(arg0: number, arg1: number): boolean;
        add(arg0: Internal.Rectangle_): void;
        /**
         * @deprecated
        */
        reshape(arg0: number, arg1: number, arg2: number, arg3: number): void;
        add(arg0: Internal.Point_): void;
        intersects(arg0: Internal.Rectangle_): boolean;
        setSize(arg0: Internal.Dimension_): void;
        getSize(): Internal.Dimension;
        translate(arg0: number, arg1: number): void;
        contains(arg0: number, arg1: number): boolean;
        setLocation(arg0: Internal.Point_): void;
        intersection(arg0: Internal.Rectangle_): this;
        setBounds(arg0: Internal.Rectangle_): void;
        add(arg0: number, arg1: number): void;
        union(arg0: Internal.Rectangle_): this;
        setLocation(arg0: number, arg1: number): void;
        getLocation(): Internal.Point;
        /**
         * @deprecated
        */
        resize(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        move(arg0: number, arg1: number): void;
        setBounds(arg0: number, arg1: number, arg2: number, arg3: number): void;
        set size(arg0: Internal.Dimension_)
        get size(): Internal.Dimension
        set location(arg0: Internal.Point_)
        set bounds(arg0: Internal.Rectangle_)
        get location(): Internal.Point
        width: number;
        height: number;
        x: number;
        y: number;
    }
    type Rectangle_ = Rectangle;
    interface IHaveBigOutline {
    }
    type IHaveBigOutline_ = IHaveBigOutline;
    interface RecipeComponent <T> {
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<T, O>;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<T>;
        key(name: string): Internal.RecipeKey<T>;
        isOutput(recipe: Internal.RecipeJS_, value: T, match: Internal.ReplacementMatch_): boolean;
        abstract read(arg0: Internal.RecipeJS_, arg1: any): T;
        orSelf(): this;
        checkEmpty(key: Internal.RecipeKey_<T>, value: T): string;
        role(): Internal.ComponentRole;
        abstract componentClass(): typeof any;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<T>;
        replaceInput(recipe: Internal.RecipeJS_, original: T, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): T;
        checkValueHasChanged(oldValue: T, newValue: T): boolean;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<T>, json: Internal.JsonObject_): void;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        componentType(): string;
        builder(): Internal.RecipeComponentBuilder;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        replaceOutput(recipe: Internal.RecipeJS_, original: T, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): T;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<T>;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<T>;
        builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        isInput(recipe: Internal.RecipeJS_, value: T, match: Internal.ReplacementMatch_): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<T>;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, T>>;
        asArray(): Internal.ArrayRecipeComponent<T>;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, T>>;
        abstract write(arg0: Internal.RecipeJS_, arg1: T): Internal.JsonElement;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<T>, json: Internal.JsonObject_): void;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<T>, map: Internal.Map_<any, any>): void;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<T, O>;
    }
    type RecipeComponent_<T> = RecipeComponent<T>;
    class AgriSoilCondition$Humidity extends Internal.Enum<Internal.AgriSoilCondition$Humidity> implements Internal.AgriSoilValue {
        isValid(): boolean;
        synonyms(): Internal.List<string>;
        static fromString(string: string): Internal.Optional<Internal.AgriSoilCondition$Humidity>;
        static valueOf(name: string): Internal.AgriSoilCondition$Humidity;
        static values(): Internal.AgriSoilCondition$Humidity[];
        isSynonym(string: string): boolean;
        get valid(): boolean
        static readonly CODEC: Internal.Codec<Internal.AgriSoilCondition$Humidity>;
        static readonly ARID: Internal.AgriSoilCondition$Humidity;
        static readonly WATERY: Internal.AgriSoilCondition$Humidity;
        static readonly DAMP: Internal.AgriSoilCondition$Humidity;
        static readonly INVALID: Internal.AgriSoilCondition$Humidity;
        static readonly FLOODED: Internal.AgriSoilCondition$Humidity;
        static readonly DRY: Internal.AgriSoilCondition$Humidity;
        static readonly WET: Internal.AgriSoilCondition$Humidity;
    }
    type AgriSoilCondition$Humidity_ = "flooded" | "damp" | "arid" | AgriSoilCondition$Humidity | "dry" | "wet" | "invalid" | "watery";
    interface ServerTickingBlockEntity {
        abstract serverTick(): void;
        (): void;
    }
    type ServerTickingBlockEntity_ = ServerTickingBlockEntity;
    class BrainDebugRenderer$BrainDump {
        constructor($$0: Internal.UUID_, $$1: number, $$2: string, $$3: string, $$4: number, $$5: number, $$6: number, $$7: Internal.Position_, $$8: string, $$9: net.minecraft.world.level.pathfinder.Path_, $$10: boolean, $$11: number)
        getUuid(): Internal.UUID;
        get uuid(): Internal.UUID
        readonly name: string;
        readonly path: net.minecraft.world.level.pathfinder.Path;
        readonly angerLevel: number;
        readonly pos: Internal.Position;
        readonly maxHealth: number;
        readonly memories: Internal.List<string>;
        readonly potentialPois: Internal.Set<BlockPos>;
        readonly wantsGolem: boolean;
        readonly activities: Internal.List<string>;
        readonly profession: string;
        readonly xp: number;
        readonly pois: Internal.Set<BlockPos>;
        readonly uuid: Internal.UUID;
        readonly id: number;
        readonly inventory: string;
        readonly health: number;
        readonly behaviors: Internal.List<string>;
        readonly gossips: Internal.List<string>;
    }
    type BrainDebugRenderer$BrainDump_ = BrainDebugRenderer$BrainDump;
    interface BlockPredicateType <P extends net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate> {
        abstract codec(): Internal.Codec<P>;
        (): Internal.Codec_<P>;
        readonly REPLACEABLE: Internal.BlockPredicateType<Internal.ReplaceablePredicate>;
        readonly MATCHING_FLUIDS: Internal.BlockPredicateType<Internal.MatchingFluidsPredicate>;
        readonly HAS_STURDY_FACE: Internal.BlockPredicateType<Internal.HasSturdyFacePredicate>;
        readonly MATCHING_BLOCK_TAG: Internal.BlockPredicateType<Internal.MatchingBlockTagPredicate>;
        readonly SOLID: Internal.BlockPredicateType<Internal.SolidPredicate>;
        readonly TRUE: Internal.BlockPredicateType<Internal.TrueBlockPredicate>;
        readonly WOULD_SURVIVE: Internal.BlockPredicateType<Internal.WouldSurvivePredicate>;
        readonly INSIDE_WORLD_BOUNDS: Internal.BlockPredicateType<Internal.InsideWorldBoundsPredicate>;
        readonly ANY_OF: Internal.BlockPredicateType<Internal.AnyOfPredicate>;
        readonly ALL_OF: Internal.BlockPredicateType<Internal.AllOfPredicate>;
        readonly MATCHING_BLOCKS: Internal.BlockPredicateType<Internal.MatchingBlocksPredicate>;
        readonly NOT: Internal.BlockPredicateType<Internal.NotPredicate>;
    }
    type BlockPredicateType_<P extends net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate> = BlockPredicateType<P> | Special.BlockPredicateType;
    interface SkinManager$SkinTextureCallback {
        abstract onSkinTextureAvailable(arg0: Internal.MinecraftProfileTexture$Type_, arg1: ResourceLocation_, arg2: Internal.MinecraftProfileTexture_): void;
        (arg0: Internal.MinecraftProfileTexture$Type, arg1: ResourceLocation, arg2: Internal.MinecraftProfileTexture): void;
    }
    type SkinManager$SkinTextureCallback_ = SkinManager$SkinTextureCallback;
    class BlockCaner extends Internal.BlockBaseGui<Internal.TileCaner> implements Internal.SimpleWaterloggedBlock {
        constructor()
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        openGui(tile: Internal.TileCaner_, p: Internal.Player_): void;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockCaner_ = BlockCaner;
    abstract class Fluid implements Internal.FluidVariantCache, Internal.FluidExtension, Internal.InjectedFluidExtension, Internal.EmiStackConvertible {
        getStateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>;
        abstract getAmount(arg0: Internal.FluidState_): number;
        abstract getHeight(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        fabric_getCachedFluidVariant(): Internal.FluidVariant;
        abstract isSource(arg0: Internal.FluidState_): boolean;
        isEmpty(): boolean;
        abstract getOwnHeight(arg0: Internal.FluidState_): number;
        abstract getBucket(): Internal.Item;
        isSame($$0: Internal.Fluid_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Fluid>;
        abstract getShape(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        defaultFluidState(): Internal.FluidState;
        abstract getTickDelay(arg0: Internal.LevelReader_): number;
        emi(amount: number): Internal.EmiStack;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        emi(): Internal.EmiStack;
        arch$registryName(): ResourceLocation;
        getFluidType(): Internal.FluidType;
        "handler$cme000$fabric-transfer-api-v1$hookGetBucketFillSound"(cir: Internal.CallbackInfoReturnable_<any>): void;
        /**
         * @deprecated
        */
        is($$0: Internal.TagKey_<Internal.Fluid>): boolean;
        get stateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>
        get empty(): boolean
        get bucket(): Internal.Item
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get fluidType(): Internal.FluidType
        static readonly FLUID_STATE_REGISTRY: Internal.IdMapper<Internal.FluidState>;
    }
    type Fluid_ = Special.Fluid | Fluid;
    class RegistrateItemModelProvider extends Internal.ItemModelProvider implements Internal.RegistrateProvider {
        constructor(parent: Internal.AbstractRegistrate_<any>, packOutput: Internal.PackOutput_, existingFileHelper: Internal.ExistingFileHelper_)
        generated(item: Internal.NonNullSupplier_<Internal.ItemLike>): Internal.ItemModelBuilder;
        blockItem(block: Internal.NonNullSupplier_<Internal.ItemLike>): Internal.ItemModelBuilder;
        blockWithInventoryModel(block: Internal.NonNullSupplier_<Internal.ItemLike>): Internal.ItemModelBuilder;
        getSide(): Internal.EnvType;
        itemTexture(item: Internal.NonNullSupplier_<Internal.ItemLike>): ResourceLocation;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        handheld(item: Internal.NonNullSupplier_<Internal.ItemLike>): Internal.ItemModelBuilder;
        name(item: Internal.NonNullSupplier_<Internal.ItemLike>): string;
        generated(item: Internal.NonNullSupplier_<Internal.ItemLike>, ...layers: ResourceLocation_[]): Internal.ItemModelBuilder;
        handheld(item: Internal.NonNullSupplier_<Internal.ItemLike>, texture: ResourceLocation_): Internal.ItemModelBuilder;
        blockItem(block: Internal.NonNullSupplier_<Internal.ItemLike>, suffix: string): Internal.ItemModelBuilder;
        blockSprite(block: Internal.NonNullSupplier_<Internal.ItemLike>): Internal.ItemModelBuilder;
        blockSprite(block: Internal.NonNullSupplier_<Internal.ItemLike>, texture: ResourceLocation_): Internal.ItemModelBuilder;
        modid(item: Internal.NonNullSupplier_<Internal.ItemLike>): string;
        get side(): Internal.EnvType
    }
    type RegistrateItemModelProvider_ = RegistrateItemModelProvider;
    interface IMapDataPacketExtension {
        abstract moonlight$getDimension(): Internal.ResourceKey<Internal.Level>;
        abstract moonlight$getCustomMapDataTag(): Internal.CompoundTag;
        abstract moonlight$sendCustomDecorations(arg0: Internal.Collection_<Internal.CustomMapDecoration>): void;
        abstract moonlight$sendCustomMapDataTag(arg0: Internal.CompoundTag_): void;
        abstract moonlight$getColorPatch(): Internal.MapItemSavedData$MapPatch;
    }
    type IMapDataPacketExtension_ = IMapDataPacketExtension;
    class TrackTargetingBlockItem$OverlapResult extends Internal.Enum<Internal.TrackTargetingBlockItem$OverlapResult> {
        static valueOf(name: string): Internal.TrackTargetingBlockItem$OverlapResult;
        static createType$railways_$md$fca01f$0(arg0: string, arg1: number, arg2: string): Internal.TrackTargetingBlockItem$OverlapResult;
        static values(): Internal.TrackTargetingBlockItem$OverlapResult[];
        static readonly NO_TRACK: Internal.TrackTargetingBlockItem$OverlapResult;
        static readonly JUNCTION: Internal.TrackTargetingBlockItem$OverlapResult;
        static readonly OCCUPIED: Internal.TrackTargetingBlockItem$OverlapResult;
        feedback: string;
        static readonly VALID: Internal.TrackTargetingBlockItem$OverlapResult;
    }
    type TrackTargetingBlockItem$OverlapResult_ = "valid" | "no_track" | "junction" | TrackTargetingBlockItem$OverlapResult | "not_straight" | "occupied";
    class LongSummaryStatistics implements Internal.LongConsumer, Internal.IntConsumer {
        constructor()
        constructor(arg0: number, arg1: number, arg2: number, arg3: number)
        getSum(): number;
        andThen(arg0: Internal.LongConsumer_): Internal.LongConsumer;
        getCount(): number;
        getAverage(): number;
        combine(arg0: Internal.LongSummaryStatistics_): void;
        getMin(): number;
        accept(arg0: number): void;
        getMax(): number;
        accept(arg0: number): void;
        andThen(arg0: Internal.IntConsumer_): Internal.IntConsumer;
        get sum(): number
        get count(): number
        get average(): number
        get min(): number
        get max(): number
    }
    type LongSummaryStatistics_ = LongSummaryStatistics;
    class LifeStealEnchantment extends Internal.Enchantment {
        constructor()
        registryName(): string;
    }
    type LifeStealEnchantment_ = LifeStealEnchantment;
    class SimpleColor implements dev.latvian.mods.rhino.mod.util.color.Color {
        constructor(v: number)
        getSerializeJS(): string;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getArgbJS(): number;
        createTextColorJS(): Internal.TextColor;
        specialEquals(o: any, shallow: boolean): boolean;
        getHexJS(): string;
        getRgbJS(): number;
        getFireworkColorJS(): number;
        get serializeJS(): string
        get argbJS(): number
        get hexJS(): string
        get rgbJS(): number
        get fireworkColorJS(): number
        static readonly BLACK: Internal.SimpleColor;
        static readonly WHITE: Internal.SimpleColor;
    }
    type SimpleColor_ = SimpleColor;
    abstract class Line2D implements Internal.Shape, Internal.Cloneable {
        clone(): any;
        contains(arg0: number, arg1: number): boolean;
        abstract getY2(): number;
        getBounds(): Internal.Rectangle;
        abstract getY1(): number;
        intersects(arg0: Internal.Rectangle2D_): boolean;
        setLine(arg0: Internal.Point2D_, arg1: Internal.Point2D_): void;
        intersectsLine(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        static relativeCCW(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
        contains(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        intersectsLine(arg0: Internal.Line2D_): boolean;
        getPathIterator(arg0: Internal.AffineTransform_, arg1: number): Internal.PathIterator;
        setLine(arg0: Internal.Line2D_): void;
        intersects(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        ptLineDistSq(arg0: number, arg1: number): number;
        static linesIntersect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): boolean;
        static ptLineDistSq(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
        abstract getBounds2D(): Internal.Rectangle2D;
        abstract setLine(arg0: number, arg1: number, arg2: number, arg3: number): void;
        contains(arg0: Internal.Rectangle2D_): boolean;
        abstract getX2(): number;
        abstract getX1(): number;
        ptLineDist(arg0: number, arg1: number): number;
        getPathIterator(arg0: Internal.AffineTransform_): Internal.PathIterator;
        static ptSegDistSq(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
        abstract getP1(): Internal.Point2D;
        static ptLineDist(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
        abstract getP2(): Internal.Point2D;
        ptLineDistSq(arg0: Internal.Point2D_): number;
        contains(arg0: Internal.Point2D_): boolean;
        ptSegDist(arg0: Internal.Point2D_): number;
        static ptSegDist(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
        ptLineDist(arg0: Internal.Point2D_): number;
        relativeCCW(arg0: Internal.Point2D_): number;
        ptSegDistSq(arg0: number, arg1: number): number;
        ptSegDist(arg0: number, arg1: number): number;
        ptSegDistSq(arg0: Internal.Point2D_): number;
        relativeCCW(arg0: number, arg1: number): number;
        get y2(): number
        get bounds(): Internal.Rectangle
        get y1(): number
        set line(arg0: Internal.Line2D_)
        get bounds2D(): Internal.Rectangle2D
        get x2(): number
        get x1(): number
        get p1(): Internal.Point2D
        get p2(): Internal.Point2D
    }
    type Line2D_ = Line2D;
    interface InjectedBucketItemExtension {
        arch$getFluid(): Internal.Fluid;
    }
    type InjectedBucketItemExtension_ = InjectedBucketItemExtension;
    class ScrubFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type ScrubFeature_ = ScrubFeature;
    class VirtualFluid extends com.tterrag.registrate.fabric.SimpleFlowableFluid {
        constructor(properties: Internal.SimpleFlowableFluid$Properties_, source: boolean)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        static createFlowing(properties: Internal.SimpleFlowableFluid$Properties_): Internal.VirtualFluid;
        arch$registryName(): ResourceLocation;
        static createSource(properties: Internal.SimpleFlowableFluid$Properties_): Internal.VirtualFluid;
    }
    type VirtualFluid_ = VirtualFluid;
    interface Targeting {
        abstract getTarget(): Internal.LivingEntity;
        get target(): Internal.LivingEntity
        (): Internal.LivingEntity_;
    }
    type Targeting_ = Targeting;
    interface TriPredicate <A, B, C> {
        abstract test(arg0: A, arg1: B, arg2: C): boolean;
        (arg0: A, arg1: B, arg2: C): boolean;
    }
    type TriPredicate_<A, B, C> = TriPredicate<A, B, C>;
    interface BalmPlayer {
        abstract getForcedPose(): Internal.Pose;
        abstract setForcedPose(arg0: Internal.Pose_): void;
        get forcedPose(): Internal.Pose
        set forcedPose(arg0: Internal.Pose_)
    }
    type BalmPlayer_ = BalmPlayer;
    class TeamPropertyArgument implements Internal.ArgumentType<Internal.TeamProperty<any>> {
        getExamples(): Internal.Collection<string>;
        parse(reader: Internal.StringReader_): Internal.TeamProperty<any>;
        static get(context: Internal.CommandContext_<Internal.CommandSourceStack>, name: string): Internal.TeamProperty<any>;
        static create(): Internal.TeamPropertyArgument;
        listSuggestions<S>(context: Internal.CommandContext_<S>, builder: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        get examples(): Internal.Collection<string>
    }
    type TeamPropertyArgument_ = TeamPropertyArgument;
    class InputMethodEvent extends Internal.AWTEvent {
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.TextHitInfo_, arg3: Internal.TextHitInfo_)
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.AttributedCharacterIterator_, arg3: number, arg4: Internal.TextHitInfo_, arg5: Internal.TextHitInfo_)
        constructor(arg0: Internal.Component_, arg1: number, arg2: number, arg3: Internal.AttributedCharacterIterator_, arg4: number, arg5: Internal.TextHitInfo_, arg6: Internal.TextHitInfo_)
        getVisiblePosition(): Internal.TextHitInfo;
        consume(): void;
        getCommittedCharacterCount(): number;
        isConsumed(): boolean;
        getText(): Internal.AttributedCharacterIterator;
        getCaret(): Internal.TextHitInfo;
        getWhen(): number;
        get visiblePosition(): Internal.TextHitInfo
        get committedCharacterCount(): number
        get consumed(): boolean
        get text(): Internal.AttributedCharacterIterator
        get caret(): Internal.TextHitInfo
        get when(): number
        static readonly INPUT_METHOD_TEXT_CHANGED: 1100;
        static readonly INPUT_METHOD_LAST: 1101;
        static readonly INPUT_METHOD_FIRST: 1100;
        static readonly CARET_POSITION_CHANGED: 1101;
    }
    type InputMethodEvent_ = InputMethodEvent;
    class ObservedTrainNameSource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type ObservedTrainNameSource_ = ObservedTrainNameSource;
    interface Recipe <C extends net.minecraft.world.Container> extends Internal.RecipeKJS {
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        abstract getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        abstract assemble(arg0: C, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        abstract matches(arg0: C, arg1: Internal.Level_): boolean;
        setGroup(group: string): void;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        abstract getId(): ResourceLocation;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: C): Internal.NonNullList<Internal.ItemStack>;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type Recipe_<C extends net.minecraft.world.Container> = Recipe<C>;
    class AdditionalItemPlacement {
        constructor(placeable: Internal.Block_)
        overrideGetPlacementState(pContext: Internal.BlockPlaceContext_): Internal.BlockState;
        overridePlace(pContext: Internal.BlockPlaceContext_): Internal.InteractionResult;
        getPlacedBlock(): Internal.Block;
        overrideUseOn(pContext: Internal.UseOnContext_, foodProperties: Internal.FoodProperties_): Internal.InteractionResult;
        static getBlockPlacer(): Internal.BlockPlacerItem;
        overrideUpdatePlacementContext(context: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        get placedBlock(): Internal.Block
        get blockPlacer(): Internal.BlockPlacerItem
    }
    type AdditionalItemPlacement_ = AdditionalItemPlacement;
    interface LootTablesKJS {
        kjs$postLootEvents(map: Internal.Map_<ResourceLocation, Internal.JsonElement>): void;
        kjs$completeReload(parsedMap: Internal.Map_<Internal.LootDataType<any>, Internal.Map<ResourceLocation, any>>, elements: Internal.Map_<Internal.LootDataId<any>, any>): void;
    }
    type LootTablesKJS_ = LootTablesKJS;
    interface Keyable {
        abstract keys<T>(arg0: Internal.DynamicOps_<T>): Internal.Stream<T>;
        forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): this;
        (arg0: Internal.DynamicOps<T>): Internal.Stream_<T>;
    }
    type Keyable_ = Keyable;
    interface ServerboundInteractPacket$Handler {
        abstract onInteraction(arg0: Internal.InteractionHand_): void;
        abstract onAttack(): void;
        abstract onInteraction(arg0: Internal.InteractionHand_, arg1: Vec3d_): void;
    }
    type ServerboundInteractPacket$Handler_ = ServerboundInteractPacket$Handler;
    abstract class InputStream implements Internal.Closeable {
        constructor()
        skipNBytes(arg0: number): void;
        readNBytes(arg0: number[], arg1: number, arg2: number): number;
        read(arg0: number[], arg1: number, arg2: number): number;
        abstract read(): number;
        readNBytes(arg0: number): number[];
        markSupported(): boolean;
        mark(arg0: number): void;
        static nullInputStream(): Internal.InputStream;
        skip(arg0: number): number;
        readAllBytes(): number[];
        close(): void;
        available(): number;
        read(arg0: number[]): number;
        reset(): void;
        transferTo(arg0: Internal.OutputStream_): number;
    }
    type InputStream_ = InputStream;
    class HexburstItem extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HexburstItem_ = HexburstItem;
    class ParticleRenderingPhase extends Internal.Enum<Internal.ParticleRenderingPhase> {
        static valueOf(name: string): Internal.ParticleRenderingPhase;
        static values(): Internal.ParticleRenderingPhase[];
        static readonly EVERYTHING: Internal.ParticleRenderingPhase;
        static readonly TRANSLUCENT: Internal.ParticleRenderingPhase;
        static readonly OPAQUE: Internal.ParticleRenderingPhase;
    }
    type ParticleRenderingPhase_ = ParticleRenderingPhase | "translucent" | "opaque" | "everything";
    class ScheduledTick <T> extends Internal.Record {
        constructor($$0: T, $$1: BlockPos_, $$2: number, $$3: number)
        constructor($$0: T, $$1: BlockPos_, $$2: number, $$3: Internal.TickPriority_, $$4: number)
        triggerTick(): number;
        pos(): BlockPos;
        subTickOrder(): number;
        static probe<T>($$0: T, $$1: BlockPos_): Internal.ScheduledTick<T>;
        type(): T;
        priority(): Internal.TickPriority;
        static readonly DRAIN_ORDER: Internal.Comparator<Internal.ScheduledTick<any>>;
        static readonly UNIQUE_TICK_HASH: Internal.Hash$Strategy<Internal.ScheduledTick<any>>;
        static readonly INTRA_TICK_DRAIN_ORDER: Internal.Comparator<Internal.ScheduledTick<any>>;
    }
    type ScheduledTick_<T> = ScheduledTick<T>;
    class FenceGateBlock extends Internal.HorizontalDirectionalBlock implements Internal.IMixinFenceGateBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.WoodType_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static connectsToDirection($$0: Internal.BlockState_, $$1: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        invokeIsWall(arg0: Internal.BlockState_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly OPEN: Internal.BooleanProperty;
        static readonly IN_WALL: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type FenceGateBlock_ = FenceGateBlock;
    class AABB {
        constructor($$0: BlockPos_)
        constructor($$0: Vec3d_, $$1: Vec3d_)
        constructor($$0: BlockPos_, $$1: BlockPos_)
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number)
        expandTowards($$0: number, $$1: number, $$2: number): this;
        distanceToSqr($$0: Vec3d_): number;
        max(axis: Internal.Direction$Axis_): number;
        inflate($$0: number): this;
        getZsize(): number;
        static unitCubeFromLowerCorner($$0: Vec3d_): Internal.AABB;
        expandTowards($$0: Vec3d_): this;
        hasNaN(): boolean;
        static ofSize($$0: Vec3d_, $$1: number, $$2: number, $$3: number): Internal.AABB;
        contains($$0: Vec3d_): boolean;
        intersect($$0: Internal.AABB_): this;
        inflate($$0: number, $$1: number, $$2: number): this;
        contains($$0: number, $$1: number, $$2: number): boolean;
        intersects($$0: Vec3d_, $$1: Vec3d_): boolean;
        min(axis: Internal.Direction$Axis_): number;
        getXsize(): number;
        move($$0: Vec3d_): this;
        minmax($$0: Internal.AABB_): this;
        static of($$0: Internal.BoundingBox_): Internal.AABB;
        intersects($$0: Internal.AABB_): boolean;
        deflate($$0: number): this;
        setMinZ($$0: number): this;
        getYsize(): number;
        getSize(): number;
        setMinY($$0: number): this;
        setMinX($$0: number): this;
        static clip($$0: Internal.Iterable_<Internal.AABB>, $$1: Vec3d_, $$2: Vec3d_, $$3: BlockPos_): Internal.BlockHitResult;
        contract($$0: number, $$1: number, $$2: number): this;
        move($$0: number, $$1: number, $$2: number): this;
        intersects($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        setMaxY($$0: number): this;
        setMaxX($$0: number): this;
        getCenter(): Vec3d;
        setMaxZ($$0: number): this;
        deflate($$0: number, $$1: number, $$2: number): this;
        move($$0: BlockPos_): this;
        clip($$0: Vec3d_, $$1: Vec3d_): Internal.Optional<Vec3d>;
        get zsize(): number
        get xsize(): number
        set minZ($$0: number)
        get ysize(): number
        get size(): number
        set minY($$0: number)
        set minX($$0: number)
        set maxY($$0: number)
        set maxX($$0: number)
        get center(): Vec3d
        set maxZ($$0: number)
        readonly minZ: number;
        readonly minY: number;
        readonly minX: number;
        readonly maxX: number;
        readonly maxY: number;
        readonly maxZ: number;
    }
    type AABB_ = [number, number, number] | [number, number, number, number, number, number] | AABB;
    class ServerboundSwingPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.InteractionHand_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getHand(): Internal.InteractionHand;
        isSkippable(): boolean;
        get hand(): Internal.InteractionHand
        get skippable(): boolean
    }
    type ServerboundSwingPacket_ = ServerboundSwingPacket;
}
declare namespace me.flashyreese.mods.sodiumextra.mixin.gui {
    interface MinecraftClientAccessor {
        getCurrentFPS(): number;
        get currentFPS(): number
    }
    type MinecraftClientAccessor_ = MinecraftClientAccessor;
}
